/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.FhirTerser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(OperationMethodBinding.class);
    private BundleTypeEnum myBundleType;
    private boolean myCanOperateAtInstanceLevel;
    private boolean myCanOperateAtServerLevel;
    private boolean myCanOperateAtTypeLevel;
    private String myDescription;
    private final boolean myIdempotent;
    private final Integer myIdParamIndex;
    private final String myName;
    private final RestOperationTypeEnum myOtherOperatiopnType;
    private List<ReturnType> myReturnParams;
    private final BaseResourceReturningMethodBinding.ReturnTypeEnum myReturnType;

    protected OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, boolean theIdempotent, String theOperationName, Class<? extends IBaseResource> theOperationType, OperationParam[] theReturnParams, BundleTypeEnum theBundleType) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Description description;
        this.myBundleType = theBundleType;
        this.myIdempotent = theIdempotent;
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        if (this.myIdParamIndex != null) {
            for (Annotation next : theMethod.getParameterAnnotations()[this.myIdParamIndex]) {
                if (!(next instanceof IdParam)) continue;
                this.myCanOperateAtTypeLevel = ((IdParam)next).optional();
            }
        } else {
            this.myCanOperateAtTypeLevel = true;
        }
        if ((description = theMethod.getAnnotation(Description.class)) != null) {
            this.myDescription = description.formalDefinition();
            if (StringUtils.isBlank((CharSequence)this.myDescription)) {
                this.myDescription = description.shortDefinition();
            }
        }
        if (StringUtils.isBlank((CharSequence)this.myDescription)) {
            this.myDescription = null;
        }
        if (StringUtils.isBlank((CharSequence)theOperationName)) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' on type " + theMethod.getDeclaringClass().getName() + " is annotated with @" + Operation.class.getSimpleName() + " but this annotation has no name defined");
        }
        if (!theOperationName.startsWith("$")) {
            theOperationName = "$" + theOperationName;
        }
        this.myName = theOperationName;
        if (theReturnTypeFromRp != null) {
            this.setResourceName(theContext.getResourceDefinition(theReturnTypeFromRp).getName());
        } else if (!Modifier.isAbstract(theOperationType.getModifiers())) {
            this.setResourceName(theContext.getResourceDefinition(theOperationType).getName());
        } else {
            this.setResourceName(null);
        }
        this.myReturnType = BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
        this.myOtherOperatiopnType = this.getResourceName() == null ? RestOperationTypeEnum.EXTENDED_OPERATION_SERVER : (this.myIdParamIndex == null ? RestOperationTypeEnum.EXTENDED_OPERATION_TYPE : RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE);
        this.myReturnParams = new ArrayList<ReturnType>();
        if (theReturnParams != null) {
            for (OperationParam next : theReturnParams) {
                ReturnType type = new ReturnType();
                type.setName(next.name());
                type.setMin(next.min());
                type.setMax(next.max());
                if (type.getMax() == -2) {
                    type.setMax(1);
                }
                if (!next.type().equals(IBase.class)) {
                    if (next.type().isInterface() || Modifier.isAbstract(next.type().getModifiers())) {
                        throw new ConfigurationException("Invalid value for @OperationParam.type(): " + next.type().getName());
                    }
                    type.setType(theContext.getElementDefinition(next.type()).getName());
                }
                this.myReturnParams.add(type);
            }
        }
        if (this.myIdParamIndex != null) {
            this.myCanOperateAtInstanceLevel = true;
        }
        if (this.getResourceName() == null) {
            this.myCanOperateAtServerLevel = true;
        }
    }

    public OperationMethodBinding(Class<?> theReturnResourceType, Class<? extends IBaseResource> theReturnTypeFromRp, Method theMethod, FhirContext theContext, Object theProvider, Operation theAnnotation) {
        this(theReturnResourceType, theReturnTypeFromRp, theMethod, theContext, theProvider, theAnnotation.idempotent(), theAnnotation.name(), theAnnotation.type(), theAnnotation.returnParameters(), theAnnotation.bundleType());
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return this.myBundleType;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.myOtherOperatiopnType;
    }

    public List<ReturnType> getReturnParams() {
        return Collections.unmodifiableList(this.myReturnParams);
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return this.myReturnType;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        String id = null;
        if (this.myIdParamIndex != null) {
            IIdType idDt = (IIdType)theArgs[this.myIdParamIndex];
            id = idDt.getValue();
        }
        IBaseParameters parameters = (IBaseParameters)this.getContext().getResourceDefinition("Parameters").newInstance();
        if (theArgs != null) {
            for (int idx = 0; idx < theArgs.length; ++idx) {
                IParameter nextParam = this.getParameters().get(idx);
                nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, (IBaseResource)parameters);
            }
        }
        return OperationMethodBinding.createOperationInvocation(this.getContext(), this.getResourceName(), id, this.myName, parameters, false);
    }

    public boolean isCanOperateAtInstanceLevel() {
        return this.myCanOperateAtInstanceLevel;
    }

    public boolean isCanOperateAtServerLevel() {
        return this.myCanOperateAtServerLevel;
    }

    public boolean isCanOperateAtTypeLevel() {
        return this.myCanOperateAtTypeLevel;
    }

    public boolean isIdempotent() {
        return this.myIdempotent;
    }

    public void setDescription(String theDescription) {
        this.myDescription = theDescription;
    }

    public static BaseHttpClientInvocation createOperationInvocation(FhirContext theContext, String theResourceName, String theId, String theOperationName, IBaseParameters theInput, boolean theUseHttpGet) {
        StringBuilder b = new StringBuilder();
        if (theResourceName != null) {
            b.append(theResourceName);
            if (StringUtils.isNotBlank((CharSequence)theId)) {
                b.append('/');
                b.append(theId);
            }
        }
        if (b.length() > 0) {
            b.append('/');
        }
        if (!theOperationName.startsWith("$")) {
            b.append("$");
        }
        b.append(theOperationName);
        if (!theUseHttpGet) {
            return new HttpPostClientInvocation(theContext, (IBaseResource)theInput, b.toString());
        }
        FhirTerser t = theContext.newTerser();
        List parameters = t.getValues((IBaseResource)theInput, "Parameters.parameter");
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        for (Object nextParameter : parameters) {
            IBaseDatatype value;
            IPrimitiveType nextNameDt = (IPrimitiveType)t.getSingleValueOrNull((IBase)nextParameter, "name");
            if (nextNameDt == null || nextNameDt.isEmpty()) {
                ourLog.warn("Ignoring input parameter with no value in Parameters.parameter.name in operation client invocation");
                continue;
            }
            String nextName = nextNameDt.getValueAsString();
            if (!params.containsKey(nextName)) {
                params.put(nextName, new ArrayList());
            }
            if ((value = (IBaseDatatype)t.getSingleValueOrNull((IBase)nextParameter, "value[x]")) == null) continue;
            if (!(value instanceof IPrimitiveType)) {
                throw new IllegalArgumentException("Can not invoke operation as HTTP GET when it has parameters with a composite (non priitive) datatype as the value. Found value: " + value.getClass().getName());
            }
            IPrimitiveType primitive = (IPrimitiveType)value;
            ((List)params.get(nextName)).add(primitive.getValueAsString());
        }
        return new HttpGetClientInvocation(theContext, params, b.toString());
    }

    public static BaseHttpClientInvocation createProcessMsgInvocation(FhirContext theContext, String theOperationName, IBaseBundle theInput, Map<String, List<String>> urlParams) {
        StringBuilder b = new StringBuilder();
        if (b.length() > 0) {
            b.append('/');
        }
        if (!theOperationName.startsWith("$")) {
            b.append("$");
        }
        b.append(theOperationName);
        BaseHttpClientInvocation.appendExtraParamsWithQuestionMark(urlParams, b, b.indexOf("?") == -1);
        return new HttpPostClientInvocation(theContext, (IBaseResource)theInput, b.toString());
    }

    public static class ReturnType {
        private int myMax;
        private int myMin;
        private String myName;
        private String myType;

        public int getMax() {
            return this.myMax;
        }

        public int getMin() {
            return this.myMin;
        }

        public String getName() {
            return this.myName;
        }

        public String getType() {
            return this.myType;
        }

        public void setMax(int theMax) {
            this.myMax = theMax;
        }

        public void setMin(int theMin) {
            this.myMin = theMin;
        }

        public void setName(String theName) {
            this.myName = theName;
        }

        public void setType(String theType) {
            this.myType = theType;
        }
    }
}

