/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ObjectUtil;
import ca.uhn.fhir.validation.BaseValidationContext;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationOptions;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ValidationContext<T>
extends BaseValidationContext<T>
implements IValidationContext<T> {
    private final IEncoder myEncoder;
    private final T myResource;
    private final EncodingEnum myResourceAsStringEncoding;
    private final ValidationOptions myOptions;
    private String myResourceAsString;

    private ValidationContext(FhirContext theContext, T theResource, IEncoder theEncoder, ValidationOptions theOptions) {
        this(theContext, theResource, theEncoder, new ArrayList<SingleValidationMessage>(), theOptions);
    }

    private ValidationContext(FhirContext theContext, T theResource, IEncoder theEncoder, List<SingleValidationMessage> theMessages, ValidationOptions theOptions) {
        super(theContext, theMessages);
        this.myResource = theResource;
        this.myEncoder = theEncoder;
        this.myOptions = theOptions;
        this.myResourceAsStringEncoding = theEncoder != null ? theEncoder.getEncoding() : null;
    }

    @Override
    public T getResource() {
        return this.myResource;
    }

    @Override
    public String getResourceAsString() {
        if (this.myResourceAsString == null) {
            this.myResourceAsString = this.myEncoder.encode();
        }
        return this.myResourceAsString;
    }

    @Override
    public EncodingEnum getResourceAsStringEncoding() {
        return this.myResourceAsStringEncoding;
    }

    @Override
    @Nonnull
    public ValidationOptions getOptions() {
        return this.myOptions;
    }

    public static <T extends IBaseResource> IValidationContext<T> forResource(final FhirContext theContext, final T theResource, ValidationOptions theOptions) {
        ObjectUtil.requireNonNull(theContext, "theContext can not be null");
        ObjectUtil.requireNonNull(theResource, "theResource can not be null");
        ValidationOptions options = (ValidationOptions)ObjectUtils.defaultIfNull((Object)theOptions, (Object)ValidationOptions.empty());
        IEncoder encoder = new IEncoder(){

            @Override
            public String encode() {
                return theContext.newJsonParser().encodeResourceToString(theResource);
            }

            @Override
            public EncodingEnum getEncoding() {
                return EncodingEnum.JSON;
            }
        };
        return new ValidationContext<T>(theContext, theResource, encoder, options);
    }

    public static IValidationContext<IBaseResource> forText(final FhirContext theContext, final String theResourceBody, ValidationOptions theOptions) {
        ObjectUtil.requireNonNull(theContext, "theContext can not be null");
        ObjectUtil.requireNotEmpty(theResourceBody, "theResourceBody can not be null or empty");
        final ValidationOptions options = (ValidationOptions)ObjectUtils.defaultIfNull((Object)theOptions, (Object)ValidationOptions.empty());
        return new BaseValidationContext<IBaseResource>(theContext){
            private EncodingEnum myEncoding;
            private IBaseResource myParsed;

            @Override
            public IBaseResource getResource() {
                if (this.myParsed == null) {
                    IParser parser = this.getResourceAsStringEncoding().newParser(this.getFhirContext());
                    LenientErrorHandler errorHandler = new LenientErrorHandler();
                    errorHandler.setErrorOnInvalidValue(false);
                    parser.setParserErrorHandler(errorHandler);
                    this.myParsed = parser.parseResource(this.getResourceAsString());
                }
                return this.myParsed;
            }

            @Override
            public String getResourceAsString() {
                return theResourceBody;
            }

            @Override
            public EncodingEnum getResourceAsStringEncoding() {
                if (this.myEncoding == null) {
                    this.myEncoding = EncodingEnum.detectEncodingNoDefault(theResourceBody);
                    if (this.myEncoding == null) {
                        throw new InvalidRequestException(Msg.code(1971) + theContext.getLocalizer().getMessage(ValidationContext.class, "unableToDetermineEncoding", new Object[0]));
                    }
                }
                return this.myEncoding;
            }

            @Override
            @Nonnull
            public ValidationOptions getOptions() {
                return options;
            }
        };
    }

    public static IValidationContext<IBaseResource> subContext(final IValidationContext<IBaseResource> theCtx, final IBaseResource theResource, ValidationOptions theOptions) {
        return new ValidationContext<IBaseResource>(theCtx.getFhirContext(), theResource, new IEncoder(){

            @Override
            public String encode() {
                return theCtx.getFhirContext().newXmlParser().encodeResourceToString(theResource);
            }

            @Override
            public EncodingEnum getEncoding() {
                return EncodingEnum.XML;
            }
        }, theCtx.getMessages(), theOptions);
    }

    private static interface IEncoder {
        public String encode();

        public EncodingEnum getEncoding();
    }
}

