/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.rest.param.DateRangeParam;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;

public class DateRangeUtil {
    @Nonnull
    public static DateRangeParam narrowDateRange(@Nullable DateRangeParam theDateRangeParam, @Nullable Date theStartInclusive, @Nullable Date theEndExclusive) {
        if (theStartInclusive == null && theEndExclusive == null) {
            return theDateRangeParam;
        }
        DateRangeParam result = theDateRangeParam == null ? new DateRangeParam() : new DateRangeParam(theDateRangeParam);
        Date startInclusive = theStartInclusive;
        if (startInclusive != null) {
            Date inputStart = result.getLowerBoundAsInstant();
            Date upperBound = result.getUpperBoundAsInstant();
            if (upperBound != null && upperBound.before(startInclusive)) {
                startInclusive = upperBound;
            }
            if (theDateRangeParam == null || inputStart == null || inputStart.before(startInclusive)) {
                result.setLowerBoundInclusive(startInclusive);
            }
        }
        if (theEndExclusive != null) {
            Date inputEnd;
            Date date = inputEnd = result.getUpperBound() == null ? null : result.getUpperBound().getValue();
            if (theDateRangeParam == null || inputEnd == null || inputEnd.after(theEndExclusive)) {
                result.setUpperBoundExclusive(theEndExclusive);
            }
        }
        return result;
    }
}

