/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DatatypeUtil {
    public static Set<String> toStringSet(List<? extends IPrimitiveType<?>> theStringList) {
        HashSet<String> retVal = new HashSet<String>();
        if (theStringList != null) {
            for (IPrimitiveType<?> string : theStringList) {
                if (string == null || string.getValue() == null) continue;
                retVal.add(string.getValueAsString());
            }
        }
        return retVal;
    }

    public static String joinStringsSpaceSeparated(List<? extends IPrimitiveType<String>> theStrings) {
        StringBuilder b = new StringBuilder();
        for (IPrimitiveType<String> iPrimitiveType : theStrings) {
            if (iPrimitiveType.isEmpty()) continue;
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(iPrimitiveType.getValue());
        }
        return b.toString();
    }

    public static String toStringValue(IPrimitiveType<?> thePrimitiveType) {
        return thePrimitiveType != null ? thePrimitiveType.getValueAsString() : null;
    }

    public static Boolean toBooleanValue(IPrimitiveType<Boolean> thePrimitiveType) {
        return thePrimitiveType != null ? thePrimitiveType.getValue() : null;
    }
}

