/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class RuntimeChildChoiceDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private List<Class<? extends IBase>> myChoiceTypes;
    private Map<String, BaseRuntimeElementDefinition<?>> myNameToChildDefinition;
    private Map<Class<? extends IBase>, String> myDatatypeToElementName;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myDatatypeToElementDefinition;
    private String myReferenceSuffix;
    private List<Class<? extends IBaseResource>> myResourceTypes;
    private List<Class<? extends IBase>> mySpecializationChoiceTypes = Collections.emptyList();

    public RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation, List<Class<? extends IBase>> theChoiceTypes) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
    }

    RuntimeChildChoiceDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
    }

    void setChoiceTypes(@Nonnull List<Class<? extends IBase>> theChoiceTypes, @Nonnull List<Class<? extends IBase>> theSpecializationChoiceTypes) {
        Validate.notNull(theChoiceTypes, (String)"theChoiceTypes must not be null", (Object[])new Object[0]);
        Validate.notNull(theSpecializationChoiceTypes, (String)"theSpecializationChoiceTypes must not be null", (Object[])new Object[0]);
        this.myChoiceTypes = Collections.unmodifiableList(theChoiceTypes);
        this.mySpecializationChoiceTypes = Collections.unmodifiableList(theSpecializationChoiceTypes);
    }

    public List<Class<? extends IBase>> getChoices() {
        return this.myChoiceTypes;
    }

    @Override
    public Set<String> getValidChildNames() {
        return this.myNameToChildDefinition.keySet();
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        assert (this.myNameToChildDefinition.containsKey(theName)) : "Can't find child '" + theName + "' in names: " + this.myNameToChildDefinition.keySet();
        return this.myNameToChildDefinition.get(theName);
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myNameToChildDefinition = new HashMap();
        this.myDatatypeToElementName = new HashMap<Class<? extends IBase>, String>();
        this.myDatatypeToElementDefinition = new HashMap();
        this.myResourceTypes = new ArrayList<Class<? extends IBaseResource>>();
        this.myReferenceSuffix = "Reference";
        this.sealAndInitializeChoiceTypes(theContext, theClassToElementDefinitions, this.mySpecializationChoiceTypes, true);
        this.sealAndInitializeChoiceTypes(theContext, theClassToElementDefinitions, this.myChoiceTypes, false);
        this.myNameToChildDefinition = Collections.unmodifiableMap(this.myNameToChildDefinition);
        this.myDatatypeToElementName = Collections.unmodifiableMap(this.myDatatypeToElementName);
        this.myDatatypeToElementDefinition = Collections.unmodifiableMap(this.myDatatypeToElementDefinition);
        this.myResourceTypes = Collections.unmodifiableList(this.myResourceTypes);
    }

    private void sealAndInitializeChoiceTypes(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions, List<Class<? extends IBase>> choiceTypes, boolean theIsSpecilization) {
        for (Class<? extends IBase> next : choiceTypes) {
            BaseRuntimeElementDefinition<?> nextDef;
            String elementName = null;
            boolean nonPreferred = false;
            if (IBaseResource.class.isAssignableFrom(next)) {
                elementName = this.getElementName() + StringUtils.capitalize((String)next.getSimpleName());
                nextDef = this.findResourceReferenceDefinition(theClassToElementDefinitions);
                if (!theIsSpecilization) {
                    this.myNameToChildDefinition.put(this.getElementName() + "Reference", nextDef);
                    this.myNameToChildDefinition.put(this.getElementName() + "Resource", nextDef);
                }
                this.myResourceTypes.add(next);
            } else {
                IRuntimeDatatypeDefinition nextDefDatatype;
                BaseRuntimeElementDefinition<?> nextDefForChoice = nextDef = theClassToElementDefinitions.get(next);
                if (nextDef instanceof IRuntimeDatatypeDefinition && (nextDefDatatype = (IRuntimeDatatypeDefinition)((Object)nextDef)).getProfileOf() != null && !IPrimitiveType.class.isAssignableFrom(next)) {
                    nextDefForChoice = null;
                    nonPreferred = true;
                    Class<? extends IBaseDatatype> profileType = nextDefDatatype.getProfileOf();
                    BaseRuntimeElementDefinition<?> elementDef = theClassToElementDefinitions.get(profileType);
                    elementName = this.getElementName() + StringUtils.capitalize((String)elementDef.getName());
                }
                if (nextDefForChoice != null) {
                    elementName = this.getElementName() + StringUtils.capitalize((String)nextDefForChoice.getName());
                }
            }
            if (!theIsSpecilization) {
                if (!(elementName == null || this.myNameToChildDefinition.containsKey(elementName) && nonPreferred)) {
                    this.myNameToChildDefinition.put(elementName, nextDef);
                }
                if (IBaseResource.class.isAssignableFrom(next) || IBaseReference.class.isAssignableFrom(next)) {
                    next = theContext.getVersion().getResourceReferenceType();
                    elementName = this.getElementName() + this.myReferenceSuffix;
                    this.myNameToChildDefinition.put(elementName, nextDef);
                }
            }
            this.myDatatypeToElementDefinition.put(next, nextDef);
            if (this.myDatatypeToElementName.containsKey(next)) {
                String existing = this.myDatatypeToElementName.get(next);
                if (existing.equals(elementName)) continue;
                throw new ConfigurationException(Msg.code(1693) + "Already have element name " + existing + " for datatype " + next.getSimpleName() + " in " + this.getElementName() + ", cannot add " + elementName);
            }
            this.myDatatypeToElementName.put(next, elementName);
        }
    }

    public List<Class<? extends IBaseResource>> getResourceTypes() {
        return this.myResourceTypes;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToElementName.get(theDatatype);
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        return this.myDatatypeToElementDefinition.get(theDatatype);
    }

    public Set<Class<? extends IBase>> getValidChildTypes() {
        return Collections.unmodifiableSet(this.myDatatypeToElementDefinition.keySet());
    }
}

