/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;

@CoverageIgnore
public class UnprocessableEntityException
extends BaseServerResponseException {
    private static final String DEFAULT_MESSAGE = "Unprocessable Entity";
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 422;

    public UnprocessableEntityException(String theMessage, IBaseOperationOutcome theOperationOutcome) {
        super(422, theMessage, theOperationOutcome);
    }

    @Deprecated
    public UnprocessableEntityException(IBaseOperationOutcome theOperationOutcome) {
        super(422, DEFAULT_MESSAGE, theOperationOutcome);
    }

    public UnprocessableEntityException(FhirContext theCtx, IBaseOperationOutcome theOperationOutcome) {
        super(422, OperationOutcomeUtil.getFirstIssueDetails(theCtx, theOperationOutcome), theOperationOutcome);
    }

    public UnprocessableEntityException(String theMessage) {
        super(422, theMessage);
    }

    public UnprocessableEntityException(String ... theMessage) {
        super(422, theMessage);
    }
}

