/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.gclient;

import ca.uhn.fhir.rest.gclient.BaseClientParam;
import ca.uhn.fhir.rest.gclient.ICriterion;
import ca.uhn.fhir.rest.gclient.IParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.QuantityCriterion;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import org.apache.commons.lang3.StringUtils;

public class QuantityClientParam
extends BaseClientParam
implements IParam {
    private String myParamName;

    public QuantityClientParam(String theParamName) {
        this.myParamName = theParamName;
    }

    public NumberClientParam.IMatches<IAndUnits> approximately() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(ParamPrefixEnum.APPROXIMATE, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(ParamPrefixEnum.APPROXIMATE, theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> exactly() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(null, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(null, theNumber);
            }
        };
    }

    @Override
    public String getParamName() {
        return this.myParamName;
    }

    public NumberClientParam.IMatches<IAndUnits> greaterThan() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(ParamPrefixEnum.GREATERTHAN, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(ParamPrefixEnum.GREATERTHAN, theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> greaterThanOrEquals() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> lessThan() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(ParamPrefixEnum.LESSTHAN, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(ParamPrefixEnum.LESSTHAN, theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> lessThanOrEquals() {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(ParamPrefixEnum.LESSTHAN_OR_EQUALS, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theNumber);
            }
        };
    }

    public NumberClientParam.IMatches<IAndUnits> withPrefix(final ParamPrefixEnum thePrefix) {
        return new NumberClientParam.IMatches<IAndUnits>(){

            @Override
            public IAndUnits number(long theNumber) {
                return new AndUnits(thePrefix, Long.toString(theNumber));
            }

            @Override
            public IAndUnits number(String theNumber) {
                return new AndUnits(thePrefix, theNumber);
            }
        };
    }

    private class AndUnits
    implements IAndUnits {
        private ParamPrefixEnum myPrefix;
        private String myValue;

        public AndUnits(ParamPrefixEnum thePrefix, String theNumber) {
            this.myPrefix = thePrefix;
            this.myValue = theNumber;
        }

        @Override
        public ICriterion<QuantityClientParam> andNoUnits() {
            return this.andUnits(null, null);
        }

        @Override
        public ICriterion<QuantityClientParam> andUnits(String theUnits) {
            return this.andUnits(null, theUnits);
        }

        @Override
        public ICriterion<QuantityClientParam> andUnits(String theSystem, String theUnits) {
            return new QuantityCriterion(QuantityClientParam.this.getParamName(), this.myPrefix, this.myValue, StringUtils.defaultString((String)theSystem), StringUtils.defaultString((String)theUnits));
        }
    }

    public static interface IAndUnits {
        public ICriterion<QuantityClientParam> andNoUnits();

        public ICriterion<QuantityClientParam> andUnits(String var1);

        public ICriterion<QuantityClientParam> andUnits(String var1, String var2);
    }
}

