/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DatatypeDef(name="uri")
public class UriDt
extends BasePrimitive<String> {
    private static final Logger ourLog = LoggerFactory.getLogger(UriDt.class);

    public UriDt() {
    }

    @SimpleSetter
    public UriDt(@SimpleSetter.Parameter(name="theUri") String theValue) {
        this.setValueAsString(theValue);
    }

    @Override
    protected String encode(String theValue) {
        return theValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UriDt other = (UriDt)obj;
        if (this.getValue() == null && other.getValue() == null) {
            return true;
        }
        if (this.getValue() == null || other.getValue() == null) {
            return false;
        }
        String normalize = this.normalize((String)this.getValue());
        String normalize2 = this.normalize((String)other.getValue());
        return normalize.equals(normalize2);
    }

    public boolean equals(String theString) {
        return StringUtils.equals((CharSequence)this.getValueAsString(), (CharSequence)theString);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        String normalize = this.normalize((String)this.getValue());
        result = 31 * result + (normalize == null ? 0 : normalize.hashCode());
        return result;
    }

    private String normalize(String theValue) {
        URI retVal;
        if (theValue == null) {
            return null;
        }
        try {
            retVal = new URI(theValue).normalize();
            String urlString = retVal.toString();
            if (urlString.endsWith("/") && urlString.length() > 1) {
                retVal = new URI(urlString.substring(0, urlString.length() - 1));
            }
        }
        catch (URISyntaxException e) {
            ourLog.debug("Failed to normalize URL '{}', message was: {}", (Object)theValue, (Object)e.toString());
            return theValue;
        }
        return retVal.toASCIIString();
    }

    @Override
    protected String parse(String theValue) {
        return theValue;
    }

    public static UriDt fromOid(String theOid) {
        if (theOid == null) {
            return new UriDt();
        }
        return new UriDt("urn:oid:" + theOid);
    }
}

