/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.logback;

import ca.pjer.logback.Lazy;
import ca.pjer.logback.metrics.AwsLogsMetricsHolder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClientBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataAlreadyAcceptedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;

class AWSLogsStub {
    private final Comparator<InputLogEvent> inputLogEventByTimestampComparator = Comparator.comparing(InputLogEvent::timestamp);
    private final String logGroupName;
    private final String logStreamName;
    private final String logRegion;
    private final String cloudWatchEndpoint;
    private final boolean verbose;
    private final String accessKeyId;
    private final String secretAccessKey;
    private String sequenceToken;
    private Long lastTimestamp;
    private int retentionTimeInDays;
    private final Lazy<CloudWatchLogsClient> lazyAwsLogs = new Lazy();

    AWSLogsStub(String logGroupName, String logStreamName, String logRegion, int retentionTimeInDays, String cloudWatchEndpoint, boolean verbose, String accessKeyId, String secretAccessKey) {
        this.logGroupName = logGroupName;
        this.logStreamName = logStreamName;
        this.logRegion = logRegion;
        this.retentionTimeInDays = retentionTimeInDays;
        this.cloudWatchEndpoint = cloudWatchEndpoint;
        this.verbose = verbose;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
    }

    private CloudWatchLogsClient awsLogs() {
        return this.lazyAwsLogs.getOrCompute(() -> {
            CloudWatchLogsClientBuilder builder;
            block6: {
                if (this.verbose) {
                    System.out.println("Creating AWSLogs Client");
                }
                builder = CloudWatchLogsClient.builder();
                if (Objects.nonNull(this.cloudWatchEndpoint)) {
                    try {
                        builder = (CloudWatchLogsClientBuilder)builder.endpointOverride(new URI(this.cloudWatchEndpoint));
                    }
                    catch (URISyntaxException e) {
                        if (!this.verbose) break block6;
                        System.out.println("Invalid endpoint endpoint URL: " + this.cloudWatchEndpoint);
                    }
                }
            }
            if (Objects.nonNull(this.logRegion)) {
                builder = (CloudWatchLogsClientBuilder)builder.region(Region.of((String)this.logRegion));
            }
            if (Objects.nonNull(this.accessKeyId) && Objects.nonNull(this.secretAccessKey)) {
                StaticCredentialsProvider credentialProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey));
                builder.credentialsProvider((AwsCredentialsProvider)credentialProvider);
            }
            CloudWatchLogsClient awsLogs = (CloudWatchLogsClient)builder.build();
            this.initLogGroup(awsLogs);
            return awsLogs;
        });
    }

    private void initLogGroup(CloudWatchLogsClient awsLogs) {
        block8: {
            block7: {
                try {
                    awsLogs.createLogGroup((CreateLogGroupRequest)CreateLogGroupRequest.builder().logGroupName(this.logGroupName).build());
                    if (this.retentionTimeInDays > 0) {
                        awsLogs.putRetentionPolicy((PutRetentionPolicyRequest)PutRetentionPolicyRequest.builder().logGroupName(this.logGroupName).retentionInDays(Integer.valueOf(this.retentionTimeInDays)).build());
                    }
                }
                catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
                }
                catch (Throwable t) {
                    if (!this.verbose) break block7;
                    t.printStackTrace();
                }
            }
            try {
                awsLogs.createLogStream((CreateLogStreamRequest)CreateLogStreamRequest.builder().logGroupName(this.logGroupName).logStreamName(this.logStreamName).build());
            }
            catch (ResourceAlreadyExistsException t) {
            }
            catch (Throwable t) {
                if (!this.verbose) break block8;
                t.printStackTrace();
            }
        }
    }

    synchronized void start() {
    }

    synchronized void stop() {
        try {
            this.awsLogs().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void logEvents(Collection<InputLogEvent> events) {
        if (events.size() > 1) {
            ArrayList<InputLogEvent> sortedEvents = new ArrayList<InputLogEvent>(events);
            Collections.sort(sortedEvents, this.inputLogEventByTimestampComparator);
            events = sortedEvents;
        }
        ArrayList<InputLogEvent> correctedEvents = new ArrayList<InputLogEvent>(events.size());
        for (InputLogEvent event : events) {
            if (this.lastTimestamp != null && event.timestamp() < this.lastTimestamp) {
                correctedEvents.add((InputLogEvent)event.toBuilder().timestamp(this.lastTimestamp).build());
                continue;
            }
            correctedEvents.add(event);
            this.lastTimestamp = event.timestamp();
        }
        AwsLogsMetricsHolder.get().incrementLogEvents(correctedEvents.size());
        AwsLogsMetricsHolder.get().incrementPutLog();
        this.logPreparedEvents(correctedEvents);
    }

    private void logPreparedEvents(Collection<InputLogEvent> events) {
        try {
            PutLogEventsRequest request = (PutLogEventsRequest)PutLogEventsRequest.builder().logGroupName(this.logGroupName).logStreamName(this.logStreamName).sequenceToken(this.sequenceToken).logEvents(events).build();
            PutLogEventsResponse result = this.awsLogs().putLogEvents(request);
            this.sequenceToken = result.nextSequenceToken();
        }
        catch (DataAlreadyAcceptedException e) {
            this.sequenceToken = e.expectedSequenceToken();
        }
        catch (InvalidSequenceTokenException e) {
            this.sequenceToken = e.expectedSequenceToken();
            this.logPreparedEvents(events);
        }
        catch (Throwable t) {
            if (this.verbose) {
                t.printStackTrace();
            }
            AwsLogsMetricsHolder.get().incrementPutLogFailed(t);
            throw t;
        }
    }
}

