/*
 * Decompiled with CFR 0.152.
 */
package ca.pjer.glbctl;

import ca.pjer.glbctl.GlbCtl;
import ca.pjer.glbctl.GlbInfo;
import ca.pjer.glbctl.GlbNode;
import ca.pjer.glbctl.GlbNodeInfo;
import ca.pjer.glbctl.GlbStat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class GlbCtlImpl
implements GlbCtl {
    private final String host;
    private final int port;
    private Socket socket;
    private PrintWriter writer;
    private BufferedReader reader;

    public GlbCtlImpl(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public GlbStat getStat() throws IOException, InterruptedException {
        this.send("getstat");
        String line = this.receive("in:");
        List cols = Stream.of(line.split("\\s+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        GlbStat stat = new GlbStat();
        stat.setInBytes(this.parseInt((String)cols.get(1)));
        stat.setOutBytes(this.parseInt((String)cols.get(3)));
        stat.setRecvBytes(this.parseInt((String)cols.get(5)));
        stat.setRecvCount(this.parseInt((String)cols.get(7)));
        stat.setSendBytes(this.parseInt((String)cols.get(9)));
        stat.setSendCount(this.parseInt((String)cols.get(11)));
        stat.setConnCreated(this.parseInt((String)cols.get(13)));
        stat.setConnConcurrent(this.parseInt((String)cols.get(15)));
        stat.setPollReadCount(this.parseInt((String)cols.get(17)));
        stat.setPollWriteCount(this.parseInt((String)cols.get(19)));
        stat.setPollCount(this.parseInt((String)cols.get(21)));
        stat.setElapsed(this.parseFloat((String)cols.get(23)));
        return stat;
    }

    @Override
    public GlbInfo getInfo() throws IOException, InterruptedException {
        String[] lines;
        this.send("getinfo");
        String res = this.receive("Destinations:");
        GlbInfo info = new GlbInfo(new LinkedHashMap<GlbNode, GlbNodeInfo>(10));
        for (String line : lines = res.split("\n")) {
            if (line.startsWith("Router:") || line.startsWith("-----") || line.startsWith("        Address       :") || line.startsWith("Destinations:")) continue;
            List cols = Stream.of(line.split("\\s+")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            String[] hostPort = ((String)cols.get(0)).split(":");
            GlbNode node = new GlbNode(hostPort[0], this.parseInt(hostPort[1]));
            GlbNodeInfo nodeInfo = new GlbNodeInfo(this.parseFloat((String)cols.get(2)), this.parseFloat((String)cols.get(3)), (String)cols.get(4), this.parseInt((String)cols.get(5)));
            info.getRouter().put(node, nodeInfo);
        }
        return info;
    }

    @Override
    public void update(GlbNode node, int weight) throws IOException, InterruptedException {
        this.send(node.getHost() + ":" + node.getPort() + ":" + weight);
        String line = this.receive("Ok", "Error");
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    void send(String req) {
        this.writer.println(req);
    }

    int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    String receive(String ... prefixes) throws IOException {
        String line;
        StringBuilder res = new StringBuilder();
        while ((line = this.reader.readLine()) != null) {
            res.append(line).append("\n");
            for (String prefix : prefixes) {
                if (!line.startsWith(prefix)) continue;
                return res.toString();
            }
        }
        return res.toString();
    }

    void connect() throws IOException {
        Socket socket;
        this.disconnect();
        this.socket = socket = new Socket(this.host, this.port);
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), true);
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
    }

    void disconnect() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.socket = null;
        this.writer = null;
        this.reader = null;
    }
}

