/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing.sfl4j;

import ca.nexapp.logging.LoggerKt;
import ca.nexapp.tracing.Trace;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u0014\u0010\u001b\u001a\u00020\u00162\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lca/nexapp/tracing/sfl4j/Slf4JTrace;", "Lca/nexapp/tracing/Trace;", "logger", "Lorg/slf4j/Logger;", "id", "", "name", "errorLevel", "Lorg/slf4j/event/Level;", "clock", "Ljava/time/Clock;", "(Lorg/slf4j/Logger;Ljava/lang/String;Ljava/lang/String;Lorg/slf4j/event/Level;Ljava/time/Clock;)V", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "metadata", "", "startedAt", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "tags", "close", "", "setMetadata", "key", "value", "setTag", "signalError", "nexapp-tracing"})
public final class Slf4JTrace
implements Trace {
    private final Instant startedAt;
    private final Map<String, String> tags;
    private final Map<String, String> metadata;
    private Exception error;
    private final Logger logger;
    private final String id;
    private final String name;
    private final Level errorLevel;
    private final Clock clock;

    @Override
    public void signalError(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.error = error;
    }

    @Override
    public void setTag(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.tags.put(name, value);
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.metadata.put(key, value);
    }

    @Override
    public void close() {
        Instant closedAt = this.clock.instant();
        Duration totalDuration = Duration.between(this.startedAt, closedAt);
        String message = "Trace [" + this.id + "] - " + this.name + " - " + totalDuration + " - " + this.tags + " - " + this.metadata;
        Exception currentError = this.error;
        if (currentError == null) {
            this.logger.info(message);
        } else {
            LoggerKt.log((Logger)this.logger, (Level)this.errorLevel, (Throwable)currentError, (String)message);
        }
    }

    public Slf4JTrace(@NotNull Logger logger, @NotNull String id, @NotNull String name, @NotNull Level errorLevel, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)errorLevel, (String)"errorLevel");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.logger = logger;
        this.id = id;
        this.name = name;
        this.errorLevel = errorLevel;
        this.clock = clock;
        this.startedAt = this.clock.instant();
        boolean bl = false;
        this.tags = new LinkedHashMap();
        bl = false;
        this.metadata = new LinkedHashMap();
    }

    public /* synthetic */ Slf4JTrace(Logger logger, String string, String string2, Level level, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            level = Level.INFO;
        }
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(logger, string, string2, level, clock);
    }
}

