/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.tracing.sentry;

import ca.nexapp.tracing.Trace;
import io.sentry.context.Context;
import io.sentry.event.Breadcrumb;
import io.sentry.event.BreadcrumbBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0014\u0010\u001f\u001a\u00020\u000f2\n\u0010 \u001a\u00060!j\u0002`\"H\u0016J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lca/nexapp/tracing/sentry/SentryTrace;", "Lca/nexapp/tracing/Trace;", "context", "Lio/sentry/context/Context;", "message", "", "startOfTrace", "Ljava/time/Instant;", "(Lio/sentry/context/Context;Ljava/lang/String;Ljava/time/Instant;)V", "level", "Lio/sentry/event/Breadcrumb$Level;", "metadata", "", "tags", "close", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "setMetadata", "key", "value", "setTag", "name", "signalError", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "toString", "nexapp-tracing"})
public final class SentryTrace
implements Trace {
    private Breadcrumb.Level level;
    private final Map<String, String> tags;
    private final Map<String, String> metadata;
    private final Context context;
    private final String message;
    private final Instant startOfTrace;

    @Override
    public void signalError(@NotNull Exception error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.level = Breadcrumb.Level.ERROR;
        this.setTag("error", error.toString());
    }

    @Override
    public void setTag(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.tags.put(name, value);
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.metadata.put(key, value);
    }

    @Override
    public void close() {
        Breadcrumb breadcrumb = new BreadcrumbBuilder().setMessage(this.message).setLevel(this.level).setTimestamp(Date.from(this.startOfTrace)).setCategory("trace").setData(MapsKt.plus(this.tags, this.metadata)).build();
        this.context.recordBreadcrumb(breadcrumb);
    }

    public SentryTrace(@NotNull Context context, @NotNull String message, @NotNull Instant startOfTrace) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)startOfTrace, (String)"startOfTrace");
        this.context = context;
        this.message = message;
        this.startOfTrace = startOfTrace;
        this.level = Breadcrumb.Level.INFO;
        boolean bl = false;
        this.tags = new LinkedHashMap();
        bl = false;
        this.metadata = new LinkedHashMap();
    }

    private final Context component1() {
        return this.context;
    }

    private final String component2() {
        return this.message;
    }

    private final Instant component3() {
        return this.startOfTrace;
    }

    @NotNull
    public final SentryTrace copy(@NotNull Context context, @NotNull String message, @NotNull Instant startOfTrace) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)startOfTrace, (String)"startOfTrace");
        return new SentryTrace(context, message, startOfTrace);
    }

    public static /* synthetic */ SentryTrace copy$default(SentryTrace sentryTrace, Context context, String string, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            context = sentryTrace.context;
        }
        if ((n & 2) != 0) {
            string = sentryTrace.message;
        }
        if ((n & 4) != 0) {
            instant = sentryTrace.startOfTrace;
        }
        return sentryTrace.copy(context, string, instant);
    }

    @NotNull
    public String toString() {
        return "SentryTrace(context=" + this.context + ", message=" + this.message + ", startOfTrace=" + this.startOfTrace + ")";
    }

    public int hashCode() {
        Context context = this.context;
        String string = this.message;
        Instant instant = this.startOfTrace;
        return ((context != null ? context.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SentryTrace)) break block3;
                SentryTrace sentryTrace = (SentryTrace)object;
                if (!Intrinsics.areEqual((Object)this.context, (Object)sentryTrace.context) || !Intrinsics.areEqual((Object)this.message, (Object)sentryTrace.message) || !Intrinsics.areEqual((Object)this.startOfTrace, (Object)sentryTrace.startOfTrace)) break block3;
            }
            return true;
        }
        return false;
    }
}

