/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.Access;
import ca.mimic.oauth2library.OAuthResponse;
import ca.mimic.oauth2library.OAuthResponseCallback;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class OAuth2Client {
    private final String clientId;
    private final String clientSecret;
    private final String site;
    private final OkHttpClient okHttpClient;
    private String scope;
    private String grantType;
    private String username;
    private String password;
    private Map<String, String> parameters;

    private OAuth2Client(Builder builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.site = builder.site;
        this.scope = builder.scope;
        this.grantType = builder.grantType;
        this.okHttpClient = builder.okHttpClient;
        this.parameters = builder.parameters;
    }

    protected String getScope() {
        return this.scope;
    }

    protected String getGrantType() {
        return this.grantType;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected String getClientSecret() {
        return this.clientSecret;
    }

    protected String getSite() {
        return this.site;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getPassword() {
        return this.password;
    }

    public OAuthResponse refreshAccessToken(String refreshToken) throws IOException {
        if (this.grantType == null) {
            this.grantType = "refresh_token";
        }
        return Access.refreshAccessToken(refreshToken, this);
    }

    public void refreshAccessToken(final String refreshToken, final OAuthResponseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OAuthResponse response = OAuth2Client.this.refreshAccessToken(refreshToken);
                    callback.onResponse(response);
                }
                catch (Exception e) {
                    OAuthResponse response = new OAuthResponse(e);
                    callback.onResponse(response);
                }
            }
        }).start();
    }

    public OAuthResponse requestAccessToken() throws IOException {
        if (this.grantType == null) {
            this.grantType = "password";
        }
        return Access.getToken(this);
    }

    public void requestAccessToken(final OAuthResponseCallback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OAuthResponse response = OAuth2Client.this.requestAccessToken();
                    callback.onResponse(response);
                }
                catch (Exception e) {
                    OAuthResponse response = new OAuthResponse(e);
                    callback.onResponse(response);
                }
            }
        }).start();
    }

    protected OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            return new OkHttpClient();
        }
        return this.okHttpClient;
    }

    protected Map<String, String> getParameters() {
        if (this.parameters == null) {
            return new HashMap<String, String>();
        }
        return this.parameters;
    }

    protected Map<String, String> getFieldsAsMap() {
        HashMap<String, String> oAuthParams = new HashMap<String, String>();
        oAuthParams.put("client_id", this.getClientId());
        oAuthParams.put("client_secret", this.getClientSecret());
        oAuthParams.put("grant_type", this.getGrantType());
        oAuthParams.put("scope", this.getScope());
        oAuthParams.put("username", this.getUsername());
        oAuthParams.put("password", this.getPassword());
        return oAuthParams;
    }

    public static class Builder {
        private final String clientId;
        private final String clientSecret;
        private final String site;
        private String scope;
        private String grantType;
        private String username;
        private String password;
        private OkHttpClient okHttpClient;
        private Map<String, String> parameters;

        public Builder(String username, String password, String clientId, String clientSecret, String site) {
            this.username = username;
            this.password = password;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.site = site;
            this.okHttpClient = null;
        }

        public Builder(String clientId, String clientSecret, String site) {
            this.username = null;
            this.password = null;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.site = site;
            this.okHttpClient = null;
        }

        public Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder okHttpClient(OkHttpClient client) {
            this.okHttpClient = client;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public OAuth2Client build() {
            return new OAuth2Client(this);
        }
    }
}

