/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.AuthState;
import ca.mimic.oauth2library.OAuth2Client;
import java.io.IOException;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

class Utils {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");

    Utils() {
    }

    protected static boolean isJsonResponse(Response response) {
        return response.body() != null && response.body().contentType().equals((Object)JSON_MEDIA_TYPE);
    }

    protected static Authenticator getAuthenticator(final OAuth2Client oAuth2Client, final AuthState authState) {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = "";
                authState.nextState();
                if (authState.isBasicAuth()) {
                    credential = Credentials.basic((String)oAuth2Client.getUsername(), (String)oAuth2Client.getPassword());
                } else if (authState.isAuthorizationAuth()) {
                    credential = Credentials.basic((String)oAuth2Client.getClientId(), (String)oAuth2Client.getClientSecret());
                } else if (authState.isFinalAuth()) {
                    return null;
                }
                System.out.println("Authenticating for response: " + response);
                System.out.println("Challenges: " + response.challenges());
                return response.request().newBuilder().addHeader("Authorization", credential).build();
            }
        };
    }

    protected static void postAddIfValid(FormBody.Builder formBodyBuilder, Map<String, String> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!Utils.isValid(entry.getValue())) continue;
            formBodyBuilder.add(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isValid(String s) {
        return s != null && s.trim().length() > 0;
    }
}

