/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.AuthState;
import ca.mimic.oauth2library.OAuth2Client;
import ca.mimic.oauth2library.OAuthException;
import ca.mimic.oauth2library.Token;
import java.io.IOException;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.json.JSONException;
import org.json.JSONObject;

class Utils {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");

    Utils() {
    }

    static boolean isJsonResponse(Response response) {
        return response.body() != null && response.body().contentType().equals((Object)JSON_MEDIA_TYPE);
    }

    static Token getSuccessTokenFromJsonResponse(Response response) throws IOException, OAuthException {
        String body = response.body().string();
        try {
            JSONObject jsonObj = new JSONObject(body);
            long expiresIn = jsonObj.getLong("expires_in");
            String tokenType = jsonObj.getString("token_type");
            String accessToken = jsonObj.getString("access_token");
            String scope = jsonObj.isNull("scope") ? null : jsonObj.getString("scope");
            String refreshToken = !jsonObj.has("refresh_token") ? null : jsonObj.getString("refresh_token");
            return new Token(expiresIn, tokenType, refreshToken, accessToken, scope);
        }
        catch (JSONException e) {
            throw new OAuthException(e, response);
        }
    }

    static Authenticator getAuthenticator(final OAuth2Client oAuth2Client, final AuthState authState) {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = "";
                authState.nextState();
                if (authState.isBasicAuth()) {
                    credential = Credentials.basic((String)oAuth2Client.getUsername(), (String)oAuth2Client.getPassword());
                } else if (authState.isAuthorizationAuth()) {
                    credential = Credentials.basic((String)oAuth2Client.getClientId(), (String)oAuth2Client.getClientSecret());
                } else if (authState.isFinalAuth()) {
                    return null;
                }
                System.out.println("Authenticating for response: " + response);
                System.out.println("Challenges: " + response.challenges());
                return response.request().newBuilder().addHeader("Authorization", credential).build();
            }
        };
    }

    static void postAddIfValid(FormBody.Builder formBodyBuilder, Map<String, String> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!Utils.isValid(entry.getValue())) continue;
            formBodyBuilder.add(entry.getKey(), entry.getValue());
        }
    }

    private static boolean isValid(String s) {
        return s != null && s.trim().length() > 0;
    }
}

