/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

public class Token {
    private final Long expiresIn;
    private final Long expiresAt;
    private final String tokenType;
    private final String refreshToken;
    private final String accessToken;
    private final String scope;

    public Token(Long expiresIn, String tokenType, String refreshToken, String accessToken, String scope) {
        this.expiresIn = expiresIn;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.accessToken = accessToken;
        this.expiresAt = expiresIn * 1000L + System.currentTimeMillis();
        this.scope = scope;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public Long getExpiresAt() {
        return this.expiresAt;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.getExpiresAt();
    }

    public String getScope() {
        return this.scope;
    }

    public String toString() {
        return "expiresIn: " + this.expiresIn + " | expiresAt: " + this.expiresAt + " | tokenType: " + this.tokenType + " | refreshToken: " + this.refreshToken + " | accessToken: " + this.accessToken + " | scope: " + this.scope;
    }
}

