/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import java.io.IOException;
import okhttp3.Response;
import org.json.JSONException;

public class OAuthException
extends RuntimeException {
    private Response response;
    private JSONException jsonException;
    private String responseBody;

    public OAuthException(JSONException e, Response response) throws IOException {
        this.jsonException = e;
        this.response = response;
        if (response != null) {
            this.responseBody = response.body().string();
        }
    }

    public OAuthException(Response response) throws IOException {
        this.response = response;
        if (response != null) {
            this.responseBody = response.body().string();
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public JSONException getJsonException() {
        return this.jsonException;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String toString() {
        return "code: " + this.response.code() + " | " + this.response.toString();
    }
}

