/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

class AuthState {
    static final int ACCESS_TOKEN = 0;
    static final int REFRESH_TOKEN = 1;
    private static final int NO_AUTH = 0;
    private static final int BASIC_AUTH = 1;
    private static final int AUTHORIZATION_AUTH = 2;
    private static final int FINAL_AUTH = 3;
    private static final int[] ACCESS_STATES = new int[]{0, 1, 2, 3};
    private static final int[] REFRESH_STATES = new int[]{0, 2, 3};
    private int[] state;
    private int tokenType;
    private int position;
    private boolean initialAuth;

    AuthState(int tokenType) {
        this.tokenType = tokenType;
        switch (tokenType) {
            case 0: {
                this.state = ACCESS_STATES;
                break;
            }
            case 1: {
                this.state = REFRESH_STATES;
            }
        }
    }

    void nextState() {
        ++this.position;
    }

    boolean isFinalAuth() {
        return this.state[this.position] == 3;
    }

    boolean isBasicAuth() {
        return this.state[this.position] == 1;
    }

    boolean isAuthorizationAuth() {
        return this.state[this.position] == 2;
    }

    public int getTokenType() {
        return this.tokenType;
    }
}

