/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.AuthState;
import ca.mimic.oauth2library.OAuth2Client;
import ca.mimic.oauth2library.OAuthException;
import ca.mimic.oauth2library.Token;
import ca.mimic.oauth2library.Utils;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Access {
    static Token refreshAccessToken(String token, OAuth2Client oAuth2Client) throws IOException, OAuthException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add("refresh_token", token);
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getFieldsAsMap());
        Request request = new Request.Builder().url(oAuth2Client.getSite()).post((RequestBody)formBodyBuilder.build()).build();
        return Access.refreshTokenFromResponse(oAuth2Client, request);
    }

    private static Token refreshTokenFromResponse(OAuth2Client oAuth2Client, Request request) throws IOException, OAuthException {
        return Access.getTokenFromResponse(oAuth2Client, oAuth2Client.getOkHttpClient(), request, new AuthState(1));
    }

    static Token getToken(OAuth2Client oAuth2Client) throws IOException, OAuthException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getFieldsAsMap());
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getParameters());
        return Access.getAccessToken(oAuth2Client, formBodyBuilder);
    }

    private static Token getAccessToken(OAuth2Client oAuth2Client, FormBody.Builder formBodyBuilder) throws IOException, OAuthException {
        Request request = new Request.Builder().url(oAuth2Client.getSite()).post((RequestBody)formBodyBuilder.build()).build();
        return Access.getTokenFromResponse(oAuth2Client, request);
    }

    private static Token getTokenFromResponse(OAuth2Client oAuth2Client, Request request) throws IOException, OAuthException {
        return Access.getTokenFromResponse(oAuth2Client, oAuth2Client.getOkHttpClient(), request, new AuthState(0));
    }

    private static Token getTokenFromResponse(OAuth2Client oAuth2Client, OkHttpClient okHttpClient, Request request, AuthState authState) throws IOException, OAuthException {
        Response response = okHttpClient.newBuilder().authenticator(Utils.getAuthenticator(oAuth2Client, authState)).build().newCall(request).execute();
        if (response.code() < 400 && Utils.isJsonResponse(response)) {
            return Utils.getSuccessTokenFromJsonResponse(response);
        }
        throw new OAuthException(response);
    }
}

