/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.ConnectivityStateManager;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.ResourceEx;
import buzz.getcoco.iot.android.SceneEx;
import buzz.getcoco.iot.android.Utils;
import buzz.getcoco.iot.android.ZoneEx;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class BaseNetworkEx<D extends Device, Z extends Zone, S extends Scene, R extends Rule>
extends Network {
    private static final String TAG = "BaseNetworkEx";
    private transient Identifier identifier;
    private transient MutableLiveData<List<D>> deviceListObservable;
    private transient MutableLiveData<List<Z>> zoneListObservable;
    private transient MutableLiveData<List<R>> ruleListObservable;
    private transient MutableLiveData<List<S>> sceneListObservable;
    private transient MutableLiveData<String> networkNameObservable;
    private transient MutableLiveData<Boolean> removeNetworkObservable;
    private transient MutableLiveData<Network.State> stateObservable;
    private transient MutableLiveData<ConnectivityStateManager.State> conStateObservable;
    private transient ImmutableList<D> deviceList;
    private transient ImmutableList<Z> zoneList;
    private transient ImmutableList<R> ruleList;
    private transient ImmutableList<S> sceneList;
    private transient boolean isRemoved;

    protected BaseNetworkEx(String id) {
        super(id);
    }

    private static <T, U extends T> U castUp(T t) {
        return (U)t;
    }

    protected void internalAddDevice(Device device) {
        super.internalAddDevice(device);
        if (null == this.deviceList) {
            return;
        }
        this.postSortedDevices();
    }

    protected void internalRemoveDevice(long deviceNodeId) {
        super.internalRemoveDevice(deviceNodeId);
        if (null == this.deviceList) {
            return;
        }
        this.postSortedDevices();
    }

    protected void internalAddZone(Zone zone) {
        super.internalAddZone(zone);
        if (null == this.zoneList) {
            return;
        }
        this.postSortedZones();
    }

    protected void internalRemoveZone(int zoneId) {
        super.internalRemoveZone(zoneId);
        if (null == this.zoneList) {
            return;
        }
        this.postSortedZones();
    }

    protected void internalAddRule(Rule rule) {
        super.internalAddRule(rule);
        if (null == this.ruleList) {
            return;
        }
        this.postSortedRules();
    }

    protected void internalRemoveRule(int ruleId) {
        super.internalRemoveRule(ruleId);
        if (null == this.ruleList) {
            return;
        }
        this.postSortedRules();
    }

    protected void internalAddScene(Scene scene) {
        super.internalAddScene(scene);
        if (null == this.sceneList) {
            return;
        }
        this.postSortedScenes();
    }

    protected void internalRemoveScene(int sceneId) {
        SceneEx scene = (SceneEx)this.getScene(sceneId);
        super.internalRemoveScene(sceneId);
        if (null != scene) {
            scene.onSceneRemoved();
        }
        if (null == this.sceneList) {
            return;
        }
        this.postSortedScenes();
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        Log.d((String)TAG, (String)("internalSetName: newName: " + name + ", ID: " + this.getId()));
        FactoryUtility.postValue(this.networkNameObservable, name);
    }

    protected void internalSetState(Network.State state) {
        super.internalSetState(state);
        Log.d((String)TAG, (String)("internalSetState: state: " + state));
        FactoryUtility.postValue(this.stateObservable, state);
    }

    protected void internalRemoveNetwork() {
        super.internalRemoveNetwork();
        Log.d((String)TAG, (String)("internalRemoveNetwork: networkName: " + this.getName() + ", isRemoved: " + this.isRemoved));
        this.isRemoved = true;
        FactoryUtility.postValue(this.removeNetworkObservable, true);
    }

    protected void onZoneUpdated(@NonNull ZoneEx zone) {
        if (0 != zone.getId()) {
            return;
        }
        this.postSortedZones();
    }

    protected void onSceneNameUpdated(Scene scene) {
        Log.d((String)TAG, (String)("onSceneNameUpdated: scene: " + scene));
        this.postSortedScenes();
    }

    protected void onRuleNameUpdated(Rule rule) {
        Log.d((String)TAG, (String)("onRuleNameUpdated: rule: " + rule));
        this.postSortedRules();
    }

    protected void onZoneNameUpdated(Zone zone) {
        Log.d((String)TAG, (String)("onZoneNameUpdated: zone: " + zone));
        this.postSortedZones();
    }

    protected void onDeviceNameUpdated(Device device) {
        Log.d((String)TAG, (String)("onDeviceNameUpdated: device: " + device));
        this.postSortedDevices();
    }

    protected void internalSetConnectivityState(ConnectivityStateManager.State connectivityState) {
        ConnectivityStateManager.State currentState = this.getConnectivityManagerState();
        super.internalSetConnectivityState(connectivityState);
        if (currentState == connectivityState) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Device d = (Device)iterator.next();
            for (Resource r : d) {
                ResourceEx rex = (ResourceEx)r;
                rex.onStateChange();
            }
        }
        FactoryUtility.postValue(this.conStateObservable, connectivityState);
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public List<D> getSortedDeviceList() {
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Device device : this.getDeviceMap().values()) {
            devices.add(device);
        }
        Collections.sort(devices, Utils.DEVICE_COMPARATOR);
        this.deviceList = ImmutableList.copyOf(devices);
        return this.deviceList;
    }

    public List<Z> getSortedZoneList() {
        boolean defaultHasResources;
        Zone defaultZone = this.getZone(0);
        ArrayList<Zone> zones = new ArrayList<Zone>();
        for (Zone zone : this.getZoneMap().values()) {
            zones.add(zone);
        }
        boolean bl = defaultHasResources = !defaultZone.getResources().isEmpty();
        if (!defaultHasResources) {
            zones.remove(defaultZone);
        }
        Collections.sort(zones, Utils.ZONE_COMPARATOR);
        this.zoneList = ImmutableList.copyOf(zones);
        return this.zoneList;
    }

    public List<R> getSortedRuleList() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Rule rule : this.getRuleMap().values()) {
            rules.add(rule);
        }
        Collections.sort(rules, Utils.RULE_COMPARATOR);
        this.ruleList = ImmutableList.copyOf(rules);
        return this.ruleList;
    }

    public List<S> getSortedSceneList() {
        ArrayList<Scene> scenes = new ArrayList<Scene>();
        for (Scene scene : this.getSceneMap().values()) {
            scenes.add(scene);
        }
        Collections.sort(scenes, Utils.SCENE_COMPARATOR);
        this.sceneList = ImmutableList.copyOf(scenes);
        return this.sceneList;
    }

    protected void postSortedZones() {
        if (null == this.zoneList) {
            return;
        }
        FactoryUtility.postValue(this.zoneListObservable, this.getSortedZoneList());
    }

    protected void postSortedScenes() {
        if (null == this.sceneList) {
            return;
        }
        FactoryUtility.postValue(this.sceneListObservable, this.getSortedSceneList());
    }

    protected void postSortedRules() {
        if (null == this.ruleList) {
            return;
        }
        FactoryUtility.postValue(this.ruleListObservable, this.getSortedRuleList());
    }

    protected void postSortedDevices() {
        if (null == this.deviceList) {
            return;
        }
        FactoryUtility.postValue(this.deviceListObservable, this.getSortedDeviceList());
    }

    public LiveData<List<D>> getDeviceListObservable() {
        return null != this.deviceListObservable ? this.deviceListObservable : (this.deviceListObservable = FactoryUtility.createLiveData(this.getSortedDeviceList()));
    }

    public LiveData<List<Z>> getZoneListObservable() {
        return null != this.zoneListObservable ? this.zoneListObservable : (this.zoneListObservable = FactoryUtility.createLiveData(this.getSortedZoneList()));
    }

    public LiveData<List<R>> getRuleListObservable() {
        return null != this.ruleListObservable ? this.ruleListObservable : (this.ruleListObservable = FactoryUtility.createLiveData(this.getSortedRuleList()));
    }

    public LiveData<List<S>> getSceneListObservable() {
        return null != this.sceneListObservable ? this.sceneListObservable : (this.sceneListObservable = FactoryUtility.createLiveData(this.getSortedSceneList()));
    }

    public LiveData<String> getNetworkNameObservable() {
        return null != this.networkNameObservable ? this.networkNameObservable : (this.networkNameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<Network.State> getStateObservable() {
        return null != this.stateObservable ? this.stateObservable : (this.stateObservable = FactoryUtility.createLiveData(this.getState()));
    }

    public LiveData<Boolean> getRemoveNetworkObservable() {
        return null != this.removeNetworkObservable ? this.removeNetworkObservable : (this.removeNetworkObservable = FactoryUtility.createLiveData(this.isRemoved));
    }

    public LiveData<ConnectivityStateManager.State> getConnectivityManageStateObservable() {
        return null != this.conStateObservable ? this.conStateObservable : (this.conStateObservable = FactoryUtility.createLiveData(this.getConnectivityManagerState()));
    }

    private void trimMemory() {
        this.deviceListObservable = FactoryUtility.nullIfEmpty(this.deviceListObservable);
        this.zoneListObservable = FactoryUtility.nullIfEmpty(this.zoneListObservable);
        this.ruleListObservable = FactoryUtility.nullIfEmpty(this.ruleListObservable);
        this.sceneListObservable = FactoryUtility.nullIfEmpty(this.sceneListObservable);
        this.networkNameObservable = FactoryUtility.nullIfEmpty(this.networkNameObservable);
        this.removeNetworkObservable = FactoryUtility.nullIfEmpty(this.removeNetworkObservable);
        this.stateObservable = FactoryUtility.nullIfEmpty(this.stateObservable);
        this.conStateObservable = FactoryUtility.nullIfEmpty(this.conStateObservable);
    }

    @NonNull
    public String toString() {
        return "NetworkEx{isRemoved=" + this.isRemoved + ", super=" + super.toString() + '}';
    }
}

