/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.ConnectivityStateManager;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.PowerSource;
import buzz.getcoco.iot.ReceiverType;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.AttributeEx;
import buzz.getcoco.iot.android.CapabilityWrapperEx;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.ZoneEx;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;

public class ResourceEx
extends Resource {
    private static final String TAG = "ResourceEx";
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<String> zoneNameObservable;
    private transient MutableLiveData<String> metadataObservable;
    private transient MutableLiveData<String> manufacturerObservable;
    private transient MutableLiveData<String> modelObservable;
    private transient MutableLiveData<String> firmWareObservable;
    private transient MutableLiveData<PowerSource> powerSourceObservable;
    private transient MutableLiveData<ReceiverType> receiverTypeObservable;
    private transient MutableLiveData<Zone> parentZoneObservable;
    private transient MutableLiveData<Boolean> resourceRemovalObservable;
    private transient MutableLiveData<List<AttributeEx>> attributeListObservable;
    private transient MutableLiveData<State> stateChangeObservable;
    private transient MutableLiveData<Boolean> resourceReadyObservable;
    private transient MutableLiveData<List<Capability>> capabilitiesObservable;
    private transient State currentState = State.OFFLINE;
    private transient ImmutableList<Capability> capabilities;
    private transient ImmutableList<AttributeEx> attributes;
    private transient Identifier id;

    protected ResourceEx(String eui, Device parentDevice, Zone parentZone) {
        super(eui, parentDevice, parentZone);
    }

    protected void internalMarkAsReady() {
        super.internalMarkAsReady();
        this.onStateChange();
    }

    protected void onStateChange() {
        if (!this.isReady()) {
            this.currentState = State.OFFLINE;
        } else {
            Network network = this.getParent().getParent();
            ConnectivityStateManager.State networkState = network.getConnectivityManagerState();
            switch (networkState) {
                case ONLINE: {
                    this.currentState = State.ONLINE;
                    break;
                }
                case LOCAL: {
                    this.currentState = State.LOCAL;
                    break;
                }
                default: {
                    this.currentState = State.OFFLINE;
                }
            }
            Log.d((String)TAG, (String)("setting: " + (Object)((Object)this.currentState) + ", for networkState: " + networkState));
        }
        this.postCurrentState();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Capability c = (Capability)iterator.next();
            for (Attribute a : c) {
                AttributeEx aEx = (AttributeEx)a;
                aEx.syncCurrentValue();
            }
        }
    }

    protected void postCurrentState() {
        Log.d((String)TAG, (String)("postCurrentState: ready: " + this.isReady() + ", currentState: " + (Object)((Object)this.currentState) + ", resource: " + this.getName()));
        FactoryUtility.postValue(this.resourceReadyObservable, this.isReady());
        FactoryUtility.postValue(this.stateChangeObservable, this.currentState);
    }

    public State getState() {
        return this.currentState;
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        FactoryUtility.postValue(this.nameObservable, name);
    }

    protected void internalSetMetadata(String metadata) {
        super.internalSetMetadata(metadata);
        FactoryUtility.postValue(this.metadataObservable, metadata);
    }

    protected void internalSetManufacturer(String manufacturer) {
        super.internalSetManufacturer(manufacturer);
        FactoryUtility.postValue(this.manufacturerObservable, manufacturer);
    }

    protected void internalSetModel(String model) {
        super.internalSetModel(model);
        FactoryUtility.postValue(this.modelObservable, model);
    }

    protected void internalSetFirmware(String firmware) {
        super.internalSetFirmware(firmware);
        FactoryUtility.postValue(this.firmWareObservable, firmware);
    }

    protected void internalSetPowerSource(PowerSource powerSource) {
        super.internalSetPowerSource(powerSource);
        FactoryUtility.postValue(this.powerSourceObservable, powerSource);
    }

    protected void internalAddCapability(Capability capability) {
        super.internalAddCapability(capability);
        ZoneEx parentZone = (ZoneEx)this.getParentZone();
        this.postCapabilities();
        this.postAttributes();
        if (null != parentZone) {
            parentZone.onResourceUpdated(this);
        }
    }

    protected void internalRemoveCapability(Capability.CapabilityId capabilityId) {
        super.internalRemoveCapability(capabilityId);
        ZoneEx parentZone = (ZoneEx)this.getParentZone();
        this.postCapabilities();
        this.postAttributes();
        if (null != parentZone) {
            parentZone.onResourceUpdated(this);
        }
    }

    protected void onCapabilitiesChanged(CapabilityWrapperEx capability) {
        ZoneEx parentZone = (ZoneEx)this.getParentZone();
        this.postAttributes();
        if (null != parentZone) {
            parentZone.onResourceUpdated(this);
        }
    }

    protected void internalSetReceiverType(ReceiverType receiverType) {
        super.internalSetReceiverType(receiverType);
        FactoryUtility.postValue(this.receiverTypeObservable, receiverType);
    }

    protected void internalSetParentZone(Zone parentZone) {
        super.internalSetParentZone(parentZone);
        FactoryUtility.postValue(this.parentZoneObservable, parentZone);
        FactoryUtility.postValue(this.zoneNameObservable, this.getParentZone().getName());
    }

    protected void onZoneNameChanged(String zoneName) {
        FactoryUtility.postValue(this.zoneNameObservable, zoneName);
    }

    protected void internalRemoveResource() {
        super.internalRemoveResource();
        FactoryUtility.postValue(this.resourceRemovalObservable, true);
    }

    private void postCapabilities() {
        if (null == this.capabilities) {
            return;
        }
        FactoryUtility.postValue(this.capabilitiesObservable, this.getCapabilities());
    }

    private void postAttributes() {
        if (null == this.attributes) {
            return;
        }
        FactoryUtility.postValue(this.attributeListObservable, this.getAttributes());
    }

    public List<Capability> getCapabilities() {
        this.capabilities = ImmutableList.copyOf(this.getCapabilityMap().values());
        return this.capabilities;
    }

    public List<AttributeEx> getAttributes() {
        ImmutableList.Builder attributeBuilder = new ImmutableList.Builder();
        for (Capability capability : this.getCapabilityMap().values()) {
            for (Attribute attribute : capability) {
                attributeBuilder.add((Object)((AttributeEx)attribute));
            }
        }
        this.attributes = attributeBuilder.build();
        return this.attributes;
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    public LiveData<String> getMetadataObservable() {
        return null != this.metadataObservable ? this.metadataObservable : (this.metadataObservable = FactoryUtility.createLiveData(this.getMetadata()));
    }

    public LiveData<String> getManufacturerObservable() {
        return null != this.manufacturerObservable ? this.manufacturerObservable : (this.manufacturerObservable = FactoryUtility.createLiveData(this.getManufacturer()));
    }

    public LiveData<String> getModelObservable() {
        return null != this.modelObservable ? this.modelObservable : (this.modelObservable = FactoryUtility.createLiveData(this.getModel()));
    }

    public LiveData<String> getFirmWareObservable() {
        return null != this.firmWareObservable ? this.firmWareObservable : (this.firmWareObservable = FactoryUtility.createLiveData(this.getFirmware()));
    }

    public LiveData<PowerSource> getPowerSourceObservable() {
        return null != this.powerSourceObservable ? this.powerSourceObservable : (this.powerSourceObservable = FactoryUtility.createLiveData(this.getPowerSource()));
    }

    public LiveData<List<Capability>> getCapabilitiesObservable() {
        return null != this.capabilitiesObservable ? this.capabilitiesObservable : (this.capabilitiesObservable = FactoryUtility.createLiveData(this.getCapabilities()));
    }

    public LiveData<ReceiverType> getReceiverTypeObservable() {
        return null != this.receiverTypeObservable ? this.receiverTypeObservable : (this.receiverTypeObservable = FactoryUtility.createLiveData(this.getReceiverType()));
    }

    public LiveData<Zone> getParentZoneObservable() {
        return null != this.parentZoneObservable ? this.parentZoneObservable : (this.parentZoneObservable = FactoryUtility.createLiveData(this.getParentZone()));
    }

    public LiveData<String> getZoneNameObservable() {
        return null != this.zoneNameObservable ? this.zoneNameObservable : (this.zoneNameObservable = FactoryUtility.createLiveData(this.getParentZone().getName()));
    }

    public LiveData<Boolean> getResourceRemovalObservable() {
        return null != this.resourceRemovalObservable ? this.resourceRemovalObservable : (this.resourceRemovalObservable = FactoryUtility.createLiveData(false));
    }

    public LiveData<State> getStateObservable() {
        return null != this.stateChangeObservable ? this.stateChangeObservable : (this.stateChangeObservable = FactoryUtility.createLiveData(this.getState()));
    }

    public MutableLiveData<Boolean> getResourceReadyObservable() {
        return null != this.resourceReadyObservable ? this.resourceReadyObservable : (this.resourceReadyObservable = FactoryUtility.createLiveData(this.isReady()));
    }

    public LiveData<List<AttributeEx>> getAttributeListObservable() {
        return null != this.attributeListObservable ? this.attributeListObservable : (this.attributeListObservable = FactoryUtility.createLiveData(this.getAttributes()));
    }

    public Identifier getIdentifier() {
        return null != this.id ? this.id : (this.id = Identifier.getIdentifier(this));
    }

    @Nullable
    public Network getParentNetwork() {
        Device d = this.getParent();
        return null == d ? null : d.getParent();
    }

    @NonNull
    public String toString() {
        return "ResourceEx{identifier=" + (Object)((Object)this.id) + ", currentState=" + (Object)((Object)this.currentState) + ", super=" + super.toString() + '}';
    }

    private void trimMemory() {
        this.id = null;
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.zoneNameObservable = FactoryUtility.nullIfEmpty(this.zoneNameObservable);
        this.metadataObservable = FactoryUtility.nullIfEmpty(this.metadataObservable);
        this.manufacturerObservable = FactoryUtility.nullIfEmpty(this.manufacturerObservable);
        this.modelObservable = FactoryUtility.nullIfEmpty(this.modelObservable);
        this.firmWareObservable = FactoryUtility.nullIfEmpty(this.firmWareObservable);
        this.powerSourceObservable = FactoryUtility.nullIfEmpty(this.powerSourceObservable);
        this.receiverTypeObservable = FactoryUtility.nullIfEmpty(this.receiverTypeObservable);
        this.parentZoneObservable = FactoryUtility.nullIfEmpty(this.parentZoneObservable);
        this.resourceRemovalObservable = FactoryUtility.nullIfEmpty(this.resourceRemovalObservable);
        this.stateChangeObservable = FactoryUtility.nullIfEmpty(this.stateChangeObservable);
        this.resourceReadyObservable = FactoryUtility.nullIfEmpty(this.resourceReadyObservable);
        this.capabilitiesObservable = FactoryUtility.nullIfEmpty(this.capabilitiesObservable);
    }

    public static enum State {
        ONLINE,
        LOCAL,
        OFFLINE;

    }
}

