package buzz.getcoco.iot.android;

import java.util.Comparator;

import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;

public final class Utils {

  private Utils() {
    throw new IllegalStateException();
  }

  // compares states first, then names
  public static final Comparator<Network> NETWORK_STATE_NAME_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    int dState = a.getState().ordinal() - b.getState().ordinal();

    if (0 != dState)
      return dState;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static final Comparator<Network> NETWORK_NAME_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static final Comparator<Scene> SCENE_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static final Comparator<Rule> RULE_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static final Comparator<Device> DEVICE_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static final Comparator<Zone> ZONE_COMPARATOR = (a, b) -> {
    if (a == b)
      return 0;

    if (null == a)
      return 1;

    if (null == b)
      return -1;

    if (a.getId() == Zone.DEFAULT_ZONE_ID && b.getId() == Zone.DEFAULT_ZONE_ID)
      return 0;

    if (Zone.DEFAULT_ZONE_ID == a.getId())
      return 1;

    if (Zone.DEFAULT_ZONE_ID == b.getId())
      return -1;

    return compareToIgnoreCase(a.getName(), b.getName());
  };

  public static int compareToIgnoreCase(String a, String b) {
    a = (null == a) ? "" : a;
    b = (null == b) ? "" : b;

    return a.compareToIgnoreCase(b);
  }
}
