/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot.android;

import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Zone;
import buzz.getcoco.iot.android.FactoryUtility;
import buzz.getcoco.iot.android.Identifier;
import buzz.getcoco.iot.android.NetworkEx;
import buzz.getcoco.iot.android.ResourceEx;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ZoneEx
extends Zone {
    private static final String TAG = "ZoneEx";
    private transient Identifier identifier;
    private transient MutableLiveData<String> nameObservable;
    private transient MutableLiveData<List<ResourceEx>> resourcesObservable;

    protected ZoneEx(int zoneId, Network parent) {
        super(zoneId, parent);
    }

    protected void internalSetName(String name) {
        super.internalSetName(name);
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onZoneNameUpdated(this);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            ((ResourceEx)resource).onZoneNameChanged(name);
        }
        FactoryUtility.postValue(this.nameObservable, name);
    }

    protected void internalRemoveResource(Resource resource) {
        super.internalRemoveResource(resource);
        this.notifyNetworkForChange();
        Log.d((String)TAG, (String)("internalRemoveResource: zone: " + (Object)((Object)this) + ", resource: " + resource));
        FactoryUtility.postValue(this.resourcesObservable, this.getCopyOfResources());
    }

    protected void internalAddResource(Resource resource) {
        super.internalAddResource(resource);
        this.notifyNetworkForChange();
        Log.d((String)TAG, (String)("internalRemoveResource: zone: " + (Object)((Object)this) + ", resource: " + resource));
        FactoryUtility.postValue(this.resourcesObservable, this.getCopyOfResources());
    }

    @CallSuper
    protected void onResourceUpdated(@NonNull ResourceEx res) {
        this.notifyNetworkForChange();
    }

    public Identifier getIdentifier() {
        return null != this.identifier ? this.identifier : (this.identifier = Identifier.getIdentifier(this));
    }

    public LiveData<String> getNameObservable() {
        return null != this.nameObservable ? this.nameObservable : (this.nameObservable = FactoryUtility.createLiveData(this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceEx> getCopyOfResources() {
        Set resources;
        ArrayList<ResourceEx> resourcesCopy = new ArrayList<ResourceEx>();
        Set set = resources = this.getResources();
        synchronized (resources) {
            for (Resource r : resources) {
                resourcesCopy.add((ResourceEx)r);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return resourcesCopy;
        }
    }

    public LiveData<List<ResourceEx>> getResourcesObservable() {
        return null != this.resourcesObservable ? this.resourcesObservable : (this.resourcesObservable = FactoryUtility.createLiveData(this.getCopyOfResources()));
    }

    private void notifyNetworkForChange() {
        NetworkEx parent = (NetworkEx)this.getParent();
        if (null != parent) {
            parent.onZoneUpdated(this);
        }
    }

    private void trimMemory() {
        this.nameObservable = FactoryUtility.nullIfEmpty(this.nameObservable);
        this.resourcesObservable = FactoryUtility.nullIfEmpty(this.resourcesObservable);
    }
}

