package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Scene;

public class SceneEx extends Scene {

  private transient Identifier id;

  private transient MutableLiveData<Boolean> removalObservable;
  private transient MutableLiveData<String> nameObservable;

  protected SceneEx(int sceneId, Network parent) {
    super(sceneId, parent);
  }

  @Override
  protected void internalSetName(String name) {
    super.internalSetName(name);

    NetworkEx parent;

    if (null != (parent = (NetworkEx) getParent())) {
      parent.onSceneNameUpdated(this);
    }

    FactoryUtility.postValue(nameObservable, name);
  }

  protected void onSceneRemoved() {
    FactoryUtility.postValue(removalObservable, true);
  }

  public boolean isRemoved() {
    return !getParent().containsScene(getId());
  }

  public LiveData<String> getNameObservable() {
    return (null != nameObservable) ? nameObservable : (nameObservable = FactoryUtility.createLiveData(getName()));
  }

  public LiveData<Boolean> getRemovalObservable() {
    return (null != removalObservable) ? removalObservable : (removalObservable = FactoryUtility.createLiveData( isRemoved() ));
  }

  public Identifier getIdentifier() {
    return (null != id) ? id : (id = Identifier.getIdentifier(this));
  }

  private void trimMemory() {
    nameObservable = FactoryUtility.nullIfEmpty(nameObservable);
    removalObservable = FactoryUtility.nullIfEmpty(removalObservable);
  }
}
