package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;

public class RuleEx extends Rule {

  private transient Identifier identifier;

  private transient List<Condition> conditions;
  private transient MutableLiveData<String> nameObservable;
  private transient MutableLiveData<List<Condition>> conditionsObservable;
  private transient MutableLiveData<List<ScheduleCondition>> scheduleConditionObservable;

  protected RuleEx(int id, Network parent) {
    super(id, parent);
  }

  @Override
  protected void internalClearAddSceneActions(Collection<Scene> scenesActions) {
    super.internalClearAddSceneActions(scenesActions);

    recompileConditions();

    FactoryUtility.postValue(conditionsObservable, conditions);
  }

  @Override
  protected void internalClearAddResourceActions(Collection<ResourceAction> resourceActions) {
    super.internalClearAddResourceActions(resourceActions);

    recompileConditions();

    FactoryUtility.postValue(conditionsObservable, conditions);
    FactoryUtility.postValue(scheduleConditionObservable, getScheduleConditions());
  }

  @Override
  protected void internalSetName(String name) {
    super.internalSetName(name);

    NetworkEx parent;

    if (null != (parent = (NetworkEx) getParent())) {
      parent.onRuleNameUpdated(this);
    }

    FactoryUtility.postValue(nameObservable, name);
  }

  private void recompileConditions() {
    if (null == conditions)
      return;

    conditions.clear();
    conditions.addAll(getScheduleConditions());
    conditions.addAll(getResourceConditions());
  }

  public Identifier getIdentifier() {
    return (null != identifier) ?  identifier : (identifier = Identifier.getIdentifier(this));
  }

  public LiveData<String> getNameObservable() {
    return (null != nameObservable) ? nameObservable : (nameObservable = new MutableLiveData<>(getName()));
  }

  public LiveData<List<Condition>> getConditionsObservable() {
    return (null != conditionsObservable) ? conditionsObservable : (conditionsObservable = FactoryUtility.createLiveData(getConditions()));
  }

  public LiveData<List<ScheduleCondition>> getScheduleConditionObservable() {
    return (null != scheduleConditionObservable) ? scheduleConditionObservable : (scheduleConditionObservable = FactoryUtility.createLiveData(getScheduleConditions()));
  }

  // included scheduleConditions & resourceConditions
  public List<Condition> getConditions() {

    if (null == conditions) {
      conditions = new ArrayList<>(getResourceConditions().size() + getScheduleConditions().size());

      recompileConditions();
    }

    return conditions;
  }

  private void trimMemory() {
    conditions = null;
    nameObservable = FactoryUtility.nullIfEmpty(nameObservable);
    conditionsObservable = FactoryUtility.nullIfEmpty(conditionsObservable);
  }
}
