package buzz.getcoco.iot.android;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

public class FactoryUtility {

  public static <T> void postValue(MutableLiveData<T> liveData, T value) {
    if (null == liveData)
      return;

    liveData.postValue(value);
  }

  public static <T> MutableLiveData<T> createLiveData(T initialValue) {
    return new MutableLiveData<>(initialValue);
  }

  public static <T, U extends LiveData<T>> U nullIfEmpty(U liveData) {
    if (null == liveData || !liveData.hasObservers())
      return null;

    return liveData;
  }
}
