package buzz.getcoco.iot.android;

import android.util.Log;

import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;

import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;

public class DeviceEx extends Device {

  private static final String TAG = "DeviceEx";

  private transient Identifier identifier;
  private transient MutableLiveData<Boolean> deviceStateObservable;
  private transient MutableLiveData<String> deviceNameObservable;
  private transient MutableLiveData<Device> deviceRemovalObservable;

  protected DeviceEx(long deviceNodeId, Network parent) {
    super(deviceNodeId, parent);
  }

  @Override
  protected void internalSetName(String deviceName) {
    NetworkEx parent;
    super.internalSetName(deviceName);

    if (null != (parent = (NetworkEx) getParent())) {
      parent.onDeviceNameUpdated(this);
    }

    Log.d(TAG, "internalSetName: " + deviceName);
    FactoryUtility.postValue(deviceNameObservable, deviceName);
  }

  @Override
  protected void internalSetReady(boolean ready) {
    super.internalSetReady(ready);

    for (Resource r : this) {
      ResourceEx rex = (ResourceEx) r;

      rex.onStateChange();
    }

    FactoryUtility.postValue(deviceStateObservable, ready);
  }

  @Override
  protected void internalRemoveDevice() {
    super.internalRemoveDevice();

    FactoryUtility.postValue(deviceRemovalObservable, this);
  }

  public LiveData<Device> getDeviceRemovalObservable() {
    return (null != deviceRemovalObservable) ? deviceRemovalObservable : (deviceRemovalObservable = new MutableLiveData<>());
  }

  public LiveData<Boolean> getDeviceStateObservable() {
    return (null != deviceStateObservable) ? deviceStateObservable : (deviceStateObservable = FactoryUtility.createLiveData(isReady()));
  }

  public LiveData<String> getDeviceNameObservable() {
    return (null != deviceNameObservable) ? deviceNameObservable : (deviceNameObservable = FactoryUtility.createLiveData(getName()));
  }

  public Identifier getIdentifier() {
    return (null != identifier) ?  identifier : (identifier = Identifier.getIdentifier(this));
  }

  private void trimMemory() {
    deviceStateObservable = FactoryUtility.nullIfEmpty(deviceStateObservable);
    deviceNameObservable = FactoryUtility.nullIfEmpty(deviceNameObservable);
  }

  @NonNull
  @Override
  public String toString() {
    return "DeviceEx{" +
        "id=" + getId() +
        ", name=" + getName() +
        ", psn=" + getDevicePsn() +
        ", productName=" + getProductName() +
        ", ready: " + isReady() +
        '}';
  }
}
