/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.api.Row;
import builders.dsl.spreadsheet.api.Sheet;
import builders.dsl.spreadsheet.query.api.PageCriterion;
import builders.dsl.spreadsheet.query.api.RowCriterion;
import builders.dsl.spreadsheet.query.api.SheetCriterion;
import builders.dsl.spreadsheet.query.simple.AbstractCriterion;
import builders.dsl.spreadsheet.query.simple.SimplePageCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleRowCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleWorkbookCriterion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class SimpleSheetCriterion
extends AbstractCriterion<Row, SheetCriterion>
implements SheetCriterion {
    private final Collection<SimpleRowCriterion> criteria = new ArrayList<SimpleRowCriterion>();
    private final SimpleWorkbookCriterion parent;

    SimpleSheetCriterion(SimpleWorkbookCriterion parent) {
        this.parent = parent;
    }

    private SimpleSheetCriterion(boolean disjoint, SimpleWorkbookCriterion parent) {
        super(disjoint);
        this.parent = parent;
    }

    @Override
    public SimpleSheetCriterion row(Consumer<RowCriterion> rowCriterion) {
        SimpleRowCriterion criterion = new SimpleRowCriterion(this);
        rowCriterion.accept(criterion);
        this.criteria.add(criterion);
        return this;
    }

    @Override
    public SimpleSheetCriterion row(int row, Consumer<RowCriterion> rowCriterion) {
        this.row(row);
        this.row((Consumer)rowCriterion);
        return this;
    }

    @Override
    public SimpleSheetCriterion page(Consumer<PageCriterion> pageCriterion) {
        SimplePageCriterion criterion = new SimplePageCriterion(this.parent);
        pageCriterion.accept(criterion);
        return this;
    }

    @Override
    public SimpleSheetCriterion row(int row) {
        this.addCondition(o -> o.getNumber() == row);
        return this;
    }

    @Override
    public SimpleSheetCriterion or(Consumer<SheetCriterion> sheetCriterion) {
        return (SimpleSheetCriterion)super.or(sheetCriterion);
    }

    @Override
    public SheetCriterion having(Predicate<Sheet> sheetPredicate) {
        this.parent.addCondition(sheetPredicate);
        return this;
    }

    @Override
    public SheetCriterion row(int from, int to) {
        this.addCondition(o -> o.getNumber() >= from && o.getNumber() <= to);
        return this;
    }

    @Override
    public SheetCriterion row(int from, int to, Consumer<RowCriterion> rowCriterion) {
        return null;
    }

    Collection<SimpleRowCriterion> getCriteria() {
        return Collections.unmodifiableCollection(this.criteria);
    }

    @Override
    SheetCriterion newDisjointCriterionInstance() {
        return new SimpleSheetCriterion(true, this.parent);
    }

    @Override
    public SheetCriterion state(Keywords.SheetState state) {
        switch (state) {
            case LOCKED: {
                this.parent.addCondition(Sheet::isLocked);
                return this;
            }
            case VISIBLE: {
                this.parent.addCondition(Sheet::isVisible);
                return this;
            }
            case HIDDEN: {
                this.parent.addCondition(Sheet::isHidden);
                return this;
            }
            case VERY_HIDDEN: {
                this.parent.addCondition(Sheet::isVeryHidden);
                return this;
            }
        }
        throw new IllegalStateException("Unknown sheet state: " + (Object)((Object)state));
    }
}

