/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.Cell;
import builders.dsl.spreadsheet.api.Row;
import builders.dsl.spreadsheet.impl.Utils;
import builders.dsl.spreadsheet.query.api.CellCriterion;
import builders.dsl.spreadsheet.query.api.RowCriterion;
import builders.dsl.spreadsheet.query.simple.AbstractCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleCellCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleSheetCriterion;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class SimpleRowCriterion
extends AbstractCriterion<Cell, RowCriterion>
implements RowCriterion {
    private final SimpleSheetCriterion parent;

    SimpleRowCriterion(SimpleSheetCriterion parent) {
        this.parent = parent;
    }

    private SimpleRowCriterion(SimpleSheetCriterion parent, boolean disjoint) {
        super(disjoint);
        this.parent = parent;
    }

    @Override
    public RowCriterion cell(int from, int to) {
        this.addCondition(o -> o.getColumn() >= from && o.getColumn() <= to);
        return this;
    }

    @Override
    public RowCriterion cell(String from, String to) {
        this.cell(Utils.parseColumn(from), Utils.parseColumn(to));
        return this;
    }

    @Override
    public RowCriterion cell(int from, int to, Consumer<CellCriterion> cellCriterion) {
        this.cell(from, to);
        this.cell((Consumer)cellCriterion);
        return this;
    }

    @Override
    public RowCriterion cell(String from, String to, Consumer<CellCriterion> cellCriterion) {
        this.cell(from, to);
        this.cell((Consumer)cellCriterion);
        return this;
    }

    @Override
    public SimpleRowCriterion cell(int column) {
        this.addCondition(o -> o.getColumn() == column);
        return this;
    }

    @Override
    public SimpleRowCriterion cell(String column) {
        this.addCondition(o -> o.getColumnAsString().equals(column));
        return this;
    }

    @Override
    public SimpleRowCriterion cell(Consumer<CellCriterion> cellCriterion) {
        SimpleCellCriterion criterion = new SimpleCellCriterion();
        cellCriterion.accept(criterion);
        this.addCondition(criterion);
        return this;
    }

    @Override
    public SimpleRowCriterion cell(int column, Consumer<CellCriterion> cellCriterion) {
        this.cell(column);
        this.cell((Consumer)cellCriterion);
        return this;
    }

    @Override
    public SimpleRowCriterion cell(String column, Consumer<CellCriterion> cellCriterion) {
        this.cell(column);
        this.cell((Consumer)cellCriterion);
        return this;
    }

    @Override
    public SimpleRowCriterion or(Consumer<RowCriterion> sheetCriterion) {
        return (SimpleRowCriterion)super.or(sheetCriterion);
    }

    @Override
    public RowCriterion having(Predicate<Row> rowPredicate) {
        this.parent.addCondition(rowPredicate);
        return this;
    }

    @Override
    RowCriterion newDisjointCriterionInstance() {
        return new SimpleRowCriterion(this.parent, true);
    }
}

