/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.query.simple;

import builders.dsl.spreadsheet.api.CellStyle;
import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.Font;
import builders.dsl.spreadsheet.api.FontStyle;
import builders.dsl.spreadsheet.query.api.FontCriterion;
import builders.dsl.spreadsheet.query.simple.SimpleCellCriterion;
import java.util.EnumSet;
import java.util.function.Predicate;

final class SimpleFontCriterion
implements FontCriterion {
    private final SimpleCellCriterion parent;

    SimpleFontCriterion(SimpleCellCriterion parent) {
        this.parent = parent;
    }

    @Override
    public SimpleFontCriterion color(String hexColor) {
        this.color(new Color(hexColor));
        return this;
    }

    @Override
    public SimpleFontCriterion color(Color color) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && color.equals(font.getColor());
        });
        return this;
    }

    @Override
    public SimpleFontCriterion color(Predicate<Color> conition) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && conition.test(font.getColor());
        });
        return this;
    }

    @Override
    public SimpleFontCriterion size(int size) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && size == font.getSize();
        });
        return this;
    }

    @Override
    public SimpleFontCriterion size(Predicate<Integer> predicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && predicate.test(font.getSize());
        });
        return this;
    }

    @Override
    public SimpleFontCriterion name(String name) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && name.equals(font.getName());
        });
        return this;
    }

    @Override
    public SimpleFontCriterion name(Predicate<String> predicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && predicate.test(font.getName());
        });
        return this;
    }

    @Override
    public SimpleFontCriterion style(FontStyle first, FontStyle ... other) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            if (font == null) {
                return false;
            }
            EnumSet<FontStyle[]> wanted = EnumSet.of(first, other);
            EnumSet<FontStyle> actual = font.getStyles();
            for (FontStyle fontStyle : wanted) {
                if (actual.contains((Object)fontStyle)) continue;
                return false;
            }
            return true;
        });
        return this;
    }

    @Override
    public SimpleFontCriterion style(Predicate<EnumSet<FontStyle>> predicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && predicate.test(font.getStyles());
        });
        return this;
    }

    @Override
    public FontCriterion having(Predicate<Font> fontPredicate) {
        this.parent.addCondition(o -> {
            CellStyle style = o.getStyle();
            if (style == null) {
                return false;
            }
            Font font = style.getFont();
            return font != null && fontPredicate.test(font);
        });
        return this;
    }
}

