/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import java.util.regex.Pattern;

public class Utils {
    public static String join(Iterable<String> array, String separator) {
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        if (separator == null) {
            separator = "";
        }
        for (String value : array) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(value);
        }
        return buffer.toString();
    }

    public static String fixName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty!");
        }
        if (name.startsWith("c") || name.startsWith("C") || name.startsWith("r") || name.startsWith("R")) {
            return "_" + name;
        }
        name = name.replaceAll("[^.0-9a-zA-Z_]", "_");
        if (!Pattern.compile("^[abd-qs-zABD-QS-Z_].*").matcher(name).matches()) {
            return Utils.fixName("_" + name);
        }
        return name;
    }

    public static int parseColumn(String column) {
        int a = 65;
        char[] chars = new StringBuilder(column).reverse().toString().toCharArray();
        int acc = 0;
        for (int i = chars.length - 1; i >= 0; --i) {
            if (i == 0) {
                acc += chars[i] - a + 1;
                continue;
            }
            acc += 26 * i * (chars[i] - a + 1);
        }
        return acc;
    }

    public static String toColumn(int number) {
        int a = 65;
        int rest = number % 26;
        int times = number / 26;
        if (rest == 0 && times == 1) {
            return "Z";
        }
        if (times > 0) {
            return Utils.toColumn(times) + (char)(rest + a - 1);
        }
        return "" + (char)(rest + a - 1);
    }
}

