/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.PageDefinition;
import builders.dsl.spreadsheet.builder.api.Resolvable;
import builders.dsl.spreadsheet.builder.api.RowDefinition;
import builders.dsl.spreadsheet.builder.api.SheetDefinition;
import builders.dsl.spreadsheet.impl.AbstractRowDefinition;
import builders.dsl.spreadsheet.impl.AbstractWorkbookDefinition;
import builders.dsl.spreadsheet.impl.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractSheetDefinition
implements SheetDefinition,
Resolvable {
    private final AbstractWorkbookDefinition workbook;
    private final List<Integer> startPositions = new ArrayList<Integer>();
    private int nextRowNumber;
    protected final Set<Integer> autoColumns = new HashSet<Integer>();
    private final Map<Integer, AbstractRowDefinition> rows = new LinkedHashMap<Integer, AbstractRowDefinition>();
    protected boolean automaticFilter;

    protected AbstractSheetDefinition(AbstractWorkbookDefinition workbook) {
        this.workbook = workbook;
    }

    protected AbstractWorkbookDefinition getWorkbook() {
        return this.workbook;
    }

    @Override
    public final SheetDefinition row() {
        this.findOrCreateRow(this.nextRowNumber++);
        return this;
    }

    private RowDefinition findOrCreateRow(int zeroBasedRowNumber) {
        AbstractRowDefinition row = this.rows.get(zeroBasedRowNumber + 1);
        if (row != null) {
            return row;
        }
        row = this.createRow(zeroBasedRowNumber);
        this.rows.put(zeroBasedRowNumber + 1, row);
        return row;
    }

    protected abstract AbstractRowDefinition createRow(int var1);

    @Override
    public final SheetDefinition row(Consumer<RowDefinition> rowDefinition) {
        RowDefinition row = this.findOrCreateRow(this.nextRowNumber++);
        rowDefinition.accept(row);
        return this;
    }

    @Override
    public final SheetDefinition row(int oneBasedRowNumber, Consumer<RowDefinition> rowDefinition) {
        if (oneBasedRowNumber <= 0) {
            throw new IllegalArgumentException("Row index is based on 1. Got: " + oneBasedRowNumber);
        }
        this.nextRowNumber = oneBasedRowNumber;
        RowDefinition poiRow = this.findOrCreateRow(oneBasedRowNumber - 1);
        rowDefinition.accept(poiRow);
        return this;
    }

    @Override
    public final SheetDefinition freeze(String column, int row) {
        return this.freeze(Utils.parseColumn(column), row);
    }

    @Override
    public final SheetDefinition freeze(int column, int row) {
        this.doFreeze(column, row);
        return this;
    }

    @Override
    public SheetDefinition state(Keywords.SheetState state) {
        switch (state) {
            case LOCKED: {
                this.doLock();
                return this;
            }
            case VISIBLE: {
                this.doShow();
                return this;
            }
            case HIDDEN: {
                this.doHide();
                return this;
            }
            case VERY_HIDDEN: {
                this.doHideCompletely();
                return this;
            }
        }
        throw new IllegalStateException("Unknown sheet state: " + (Object)((Object)state));
    }

    protected abstract void doHide();

    protected abstract void doHideCompletely();

    protected abstract void doShow();

    protected abstract void doLock();

    @Override
    public final SheetDefinition password(String password) {
        this.doPassword(password);
        return this;
    }

    protected abstract void doPassword(String var1);

    protected abstract void doFreeze(int var1, int var2);

    @Override
    public final SheetDefinition collapse(Consumer<SheetDefinition> insideGroupDefinition) {
        this.createGroup(true, insideGroupDefinition);
        return this;
    }

    @Override
    public final SheetDefinition group(Consumer<SheetDefinition> insideGroupDefinition) {
        this.createGroup(false, insideGroupDefinition);
        return this;
    }

    @Override
    public final SheetDefinition filter(Keywords.Auto auto) {
        this.automaticFilter = true;
        return this;
    }

    @Override
    public final SheetDefinition page(Consumer<PageDefinition> pageDefinition) {
        PageDefinition page = this.createPageDefinition();
        pageDefinition.accept(page);
        return this;
    }

    protected abstract PageDefinition createPageDefinition();

    private void createGroup(boolean collapsed, Consumer<SheetDefinition> insideGroupDefinition) {
        this.startPositions.add(this.nextRowNumber);
        insideGroupDefinition.accept(this);
        int startPosition = this.startPositions.remove(this.startPositions.size() - 1);
        if (this.nextRowNumber - startPosition > 0) {
            int endPosition = this.nextRowNumber - 1;
            this.applyRowGroup(startPosition, endPosition, collapsed);
        }
    }

    protected abstract void applyRowGroup(int var1, int var2, boolean var3);

    public void addAutoColumn(int i) {
        this.autoColumns.add(i);
    }

    protected abstract void processAutoColumns();

    protected abstract void processAutomaticFilter();

    public String toString() {
        return "Sheet[" + this.getName() + "]";
    }

    protected abstract String getName();

    @Override
    public void resolve() {
        this.processAutomaticFilter();
        this.processAutoColumns();
    }
}

