/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.builder.api.CellDefinition;
import builders.dsl.spreadsheet.builder.api.Resolvable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractPendingFormula
implements Resolvable {
    private final CellDefinition cell;
    private final String formula;

    protected AbstractPendingFormula(CellDefinition cell, String formula) {
        this.cell = cell;
        this.formula = formula;
    }

    @Override
    public final void resolve() {
        String expandedFormula = this.expandNames(this.formula);
        this.doResolve(expandedFormula);
    }

    protected abstract void doResolve(String var1);

    private String expandNames(String withNames) {
        Matcher matcher = Pattern.compile("#\\{(.+?)\\}").matcher(withNames);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer(withNames.length() + 16);
            do {
                String replacement = this.findRefersToFormula(matcher.group(1));
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return withNames;
    }

    protected abstract String findRefersToFormula(String var1);

    public final CellDefinition getCell() {
        return this.cell;
    }

    public final String getFormula() {
        return this.formula;
    }
}

