/*
 * Decompiled with CFR 0.152.
 */
package builders.dsl.spreadsheet.impl;

import builders.dsl.spreadsheet.api.Color;
import builders.dsl.spreadsheet.api.ForegroundFill;
import builders.dsl.spreadsheet.api.Keywords;
import builders.dsl.spreadsheet.builder.api.BorderDefinition;
import builders.dsl.spreadsheet.builder.api.CellStyleDefinition;
import builders.dsl.spreadsheet.builder.api.FontDefinition;
import builders.dsl.spreadsheet.builder.api.Sealable;
import builders.dsl.spreadsheet.impl.AbstractBorderDefinition;
import builders.dsl.spreadsheet.impl.AbstractCellDefinition;
import builders.dsl.spreadsheet.impl.AbstractWorkbookDefinition;
import java.util.function.Consumer;

public abstract class AbstractCellStyleDefinition
implements CellStyleDefinition,
Sealable {
    protected final AbstractWorkbookDefinition workbook;
    private FontDefinition font;
    private AbstractBorderDefinition border;
    private boolean sealed;

    protected AbstractCellStyleDefinition(AbstractCellDefinition cell) {
        this.workbook = cell.getRow().getSheet().getWorkbook();
    }

    protected AbstractCellStyleDefinition(AbstractWorkbookDefinition workbook) {
        this.workbook = workbook;
    }

    @Override
    public final CellStyleDefinition base(String stylename) {
        this.checkSealed();
        this.workbook.getStyleDefinition(stylename).accept(this);
        return this;
    }

    @Override
    public final void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("The cell style is already sealed! You need to create new style. Use 'styles' method to combine multiple named styles! Create new named style if you're trying to update existing style with closure definition.");
        }
    }

    @Override
    public final boolean isSealed() {
        return this.sealed;
    }

    @Override
    public final CellStyleDefinition background(String hexColor) {
        this.checkSealed();
        this.doBackground(hexColor);
        return this;
    }

    protected abstract void doBackground(String var1);

    @Override
    public final CellStyleDefinition background(Color colorPreset) {
        this.checkSealed();
        this.background(colorPreset.getHex());
        return this;
    }

    @Override
    public final CellStyleDefinition foreground(String hexColor) {
        this.checkSealed();
        this.doForeground(hexColor);
        return this;
    }

    protected abstract void doForeground(String var1);

    @Override
    public final CellStyleDefinition foreground(Color colorPreset) {
        this.checkSealed();
        this.foreground(colorPreset.getHex());
        return this;
    }

    @Override
    public final CellStyleDefinition fill(ForegroundFill fill) {
        this.checkSealed();
        this.doFill(fill);
        return this;
    }

    protected abstract void doFill(ForegroundFill var1);

    @Override
    public final CellStyleDefinition font(Consumer<FontDefinition> fontConfiguration) {
        this.checkSealed();
        if (this.font == null) {
            this.font = this.createFont();
        }
        fontConfiguration.accept(this.font);
        return this;
    }

    protected abstract FontDefinition createFont();

    @Override
    public final CellStyleDefinition indent(int indent) {
        this.checkSealed();
        this.doIndent(indent);
        return this;
    }

    protected abstract void doIndent(int var1);

    @Override
    public final CellStyleDefinition wrap(Keywords.Text text) {
        this.checkSealed();
        this.doWrapText();
        return this;
    }

    protected abstract void doWrapText();

    @Override
    public final CellStyleDefinition rotation(int rotation) {
        this.checkSealed();
        this.doRotation(rotation);
        return this;
    }

    protected abstract void doRotation(int var1);

    @Override
    public final CellStyleDefinition format(String format) {
        this.checkSealed();
        this.doFormat(format);
        return this;
    }

    protected abstract void doFormat(String var1);

    @Override
    public final CellStyleDefinition align(Keywords.VerticalAlignment verticalAlignment, Keywords.HorizontalAlignment horizontalAlignment) {
        this.checkSealed();
        this.doAlign(verticalAlignment, horizontalAlignment);
        return this;
    }

    protected abstract void doAlign(Keywords.VerticalAlignment var1, Keywords.HorizontalAlignment var2);

    @Override
    public final CellStyleDefinition border(Consumer<BorderDefinition> borderConfiguration) {
        this.checkSealed();
        AbstractBorderDefinition poiBorder = this.findOrCreateBorder();
        borderConfiguration.accept(poiBorder);
        for (Keywords.BorderSide side : Keywords.BorderSide.BORDER_SIDES) {
            poiBorder.applyTo(side);
        }
        return this;
    }

    @Override
    public final CellStyleDefinition border(Keywords.BorderSide location, Consumer<BorderDefinition> borderConfiguration) {
        this.checkSealed();
        AbstractBorderDefinition poiBorder = this.findOrCreateBorder();
        borderConfiguration.accept(poiBorder);
        poiBorder.applyTo(location);
        return this;
    }

    @Override
    public final CellStyleDefinition border(Keywords.BorderSide first, Keywords.BorderSide second, Consumer<BorderDefinition> borderConfiguration) {
        this.checkSealed();
        AbstractBorderDefinition poiBorder = this.findOrCreateBorder();
        borderConfiguration.accept(poiBorder);
        poiBorder.applyTo(first);
        poiBorder.applyTo(second);
        return this;
    }

    @Override
    public final CellStyleDefinition border(Keywords.BorderSide first, Keywords.BorderSide second, Keywords.BorderSide third, Consumer<BorderDefinition> borderConfiguration) {
        this.checkSealed();
        AbstractBorderDefinition poiBorder = this.findOrCreateBorder();
        borderConfiguration.accept(poiBorder);
        poiBorder.applyTo(first);
        poiBorder.applyTo(second);
        poiBorder.applyTo(third);
        return this;
    }

    private AbstractBorderDefinition findOrCreateBorder() {
        if (this.border == null) {
            this.border = this.createBorder();
        }
        return this.border;
    }

    protected abstract AbstractBorderDefinition createBorder();

    @Override
    public final void seal() {
        this.sealed = true;
    }

    protected abstract void assignTo(AbstractCellDefinition var1);
}

