/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.FieldPathUtils;
import build.buf.protovalidate.Violation;
import build.buf.validate.Violations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidationResult {
    private final List<Violation> violations;
    public static final ValidationResult EMPTY = new ValidationResult(Collections.emptyList());

    public ValidationResult(List<Violation> violations) {
        this.violations = violations;
    }

    public boolean isSuccess() {
        return this.violations.isEmpty();
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isSuccess()) {
            builder.append("Validation OK");
        } else {
            builder.append("Validation error:");
            for (Violation violation : this.violations) {
                builder.append("\n - ");
                if (violation.toProto().hasField()) {
                    builder.append(FieldPathUtils.fieldPathString(violation.toProto().getField()));
                    builder.append(": ");
                }
                builder.append(String.format("%s [%s]", violation.toProto().getMessage(), violation.toProto().getRuleId()));
            }
        }
        return builder.toString();
    }

    public Violations toProto() {
        ArrayList<build.buf.validate.Violation> protoViolations = new ArrayList<build.buf.validate.Violation>();
        for (Violation violation : this.violations) {
            protoViolations.add(violation.toProto());
        }
        return Violations.newBuilder().addAllViolations(protoViolations).build();
    }
}

