/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.validate.FieldPathElement;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;

final class OneofEvaluator
implements Evaluator {
    private final Descriptors.OneofDescriptor descriptor;
    private final boolean required;

    OneofEvaluator(Descriptors.OneofDescriptor descriptor, boolean required) {
        this.descriptor = descriptor;
        this.required = required;
    }

    @Override
    public boolean tautology() {
        return !this.required;
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Message message = val.messageValue();
        if (message == null || !this.required || message.getOneofFieldDescriptor(this.descriptor) != null) {
            return RuleViolation.NO_VIOLATIONS;
        }
        return Collections.singletonList(RuleViolation.newBuilder().addFirstFieldPathElement(FieldPathElement.newBuilder().setFieldName(this.descriptor.getName()).build()).setRuleId("required").setMessage("exactly one field is required in oneof"));
    }
}

