/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Evaluator;
import build.buf.protovalidate.RuleViolation;
import build.buf.protovalidate.Value;
import build.buf.protovalidate.exceptions.ExecutionException;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class MessageOneofEvaluator
implements Evaluator {
    final List<Descriptors.FieldDescriptor> fields;
    final boolean required;

    MessageOneofEvaluator(List<Descriptors.FieldDescriptor> fields, boolean required) {
        this.fields = fields;
        this.required = required;
    }

    @Override
    public boolean tautology() {
        return false;
    }

    @Override
    public List<RuleViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Message msg = val.messageValue();
        if (msg == null) {
            return RuleViolation.NO_VIOLATIONS;
        }
        int hasCount = 0;
        for (Descriptors.FieldDescriptor field : this.fields) {
            if (!msg.hasField(field)) continue;
            ++hasCount;
        }
        if (hasCount > 1) {
            return Collections.singletonList(RuleViolation.newBuilder().setRuleId("message.oneof").setMessage(String.format("only one of %s can be set", this.fieldNames())));
        }
        if (this.required && hasCount == 0) {
            return Collections.singletonList(RuleViolation.newBuilder().setRuleId("message.oneof").setMessage(String.format("one of %s must be set", this.fieldNames())));
        }
        return Collections.emptyList();
    }

    String fieldNames() {
        return this.fields.stream().map(Descriptors.FieldDescriptor::getName).collect(Collectors.joining(", "));
    }
}

