/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.ByteString;
import io.envoyproxy.pgv.BytesValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import tests.harness.cases.WktWrappers;

public class WktWrappersValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(WktWrappers.WrapperNone.class)) {
            return new WrapperNoneValidator();
        }
        if (clazz.equals(WktWrappers.WrapperFloat.class)) {
            return new WrapperFloatValidator();
        }
        if (clazz.equals(WktWrappers.WrapperDouble.class)) {
            return new WrapperDoubleValidator();
        }
        if (clazz.equals(WktWrappers.WrapperInt64.class)) {
            return new WrapperInt64Validator();
        }
        if (clazz.equals(WktWrappers.WrapperInt32.class)) {
            return new WrapperInt32Validator();
        }
        if (clazz.equals(WktWrappers.WrapperUInt64.class)) {
            return new WrapperUInt64Validator();
        }
        if (clazz.equals(WktWrappers.WrapperUInt32.class)) {
            return new WrapperUInt32Validator();
        }
        if (clazz.equals(WktWrappers.WrapperBool.class)) {
            return new WrapperBoolValidator();
        }
        if (clazz.equals(WktWrappers.WrapperString.class)) {
            return new WrapperStringValidator();
        }
        if (clazz.equals(WktWrappers.WrapperBytes.class)) {
            return new WrapperBytesValidator();
        }
        if (clazz.equals(WktWrappers.WrapperRequiredString.class)) {
            return new WrapperRequiredStringValidator();
        }
        if (clazz.equals(WktWrappers.WrapperRequiredEmptyString.class)) {
            return new WrapperRequiredEmptyStringValidator();
        }
        if (clazz.equals(WktWrappers.WrapperOptionalUuidString.class)) {
            return new WrapperOptionalUuidStringValidator();
        }
        if (clazz.equals(WktWrappers.WrapperRequiredFloat.class)) {
            return new WrapperRequiredFloatValidator();
        }
        return null;
    }

    public static class WrapperNoneValidator
    implements ValidatorImpl<WktWrappers.WrapperNone> {
        public void assertValid(WktWrappers.WrapperNone proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                index.validatorFor((Object)proto.getVal()).assertValid((Object)proto.getVal());
            }
        }
    }

    public static class WrapperFloatValidator
    implements ValidatorImpl<WktWrappers.WrapperFloat> {
        private final Float VAL__GT = Float.valueOf(0.0f);

        public void assertValid(WktWrappers.WrapperFloat proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperFloat.val", (Object)Float.valueOf(proto.getVal().getValue()), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperDoubleValidator
    implements ValidatorImpl<WktWrappers.WrapperDouble> {
        private final Double VAL__GT = 0.0;

        public void assertValid(WktWrappers.WrapperDouble proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperDouble.val", (Object)proto.getVal().getValue(), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperInt64Validator
    implements ValidatorImpl<WktWrappers.WrapperInt64> {
        private final Long VAL__GT = 0L;

        public void assertValid(WktWrappers.WrapperInt64 proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperInt64.val", (Object)proto.getVal().getValue(), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperInt32Validator
    implements ValidatorImpl<WktWrappers.WrapperInt32> {
        private final Integer VAL__GT = 0;

        public void assertValid(WktWrappers.WrapperInt32 proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperInt32.val", (Object)proto.getVal().getValue(), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperUInt64Validator
    implements ValidatorImpl<WktWrappers.WrapperUInt64> {
        private final Long VAL__GT = 0L;

        public void assertValid(WktWrappers.WrapperUInt64 proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperUInt64.val", (Object)proto.getVal().getValue(), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperUInt32Validator
    implements ValidatorImpl<WktWrappers.WrapperUInt32> {
        private final Integer VAL__GT = 0;

        public void assertValid(WktWrappers.WrapperUInt32 proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperUInt32.val", (Object)proto.getVal().getValue(), (Object)this.VAL__GT, Comparator.naturalOrder());
            }
        }
    }

    public static class WrapperBoolValidator
    implements ValidatorImpl<WktWrappers.WrapperBool> {
        public void assertValid(WktWrappers.WrapperBool proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                ConstantValidation.constant((String)".tests.harness.cases.WrapperBool.val", (Object)proto.getVal().getValue(), (Object)true);
            }
        }
    }

    public static class WrapperStringValidator
    implements ValidatorImpl<WktWrappers.WrapperString> {
        public void assertValid(WktWrappers.WrapperString proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                StringValidation.suffix((String)".tests.harness.cases.WrapperString.val", (String)proto.getVal().getValue(), (String)"bar");
            }
        }
    }

    public static class WrapperBytesValidator
    implements ValidatorImpl<WktWrappers.WrapperBytes> {
        public void assertValid(WktWrappers.WrapperBytes proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                BytesValidation.minLength((String)".tests.harness.cases.WrapperBytes.val", (ByteString)proto.getVal().getValue(), (int)3);
            }
        }
    }

    public static class WrapperRequiredStringValidator
    implements ValidatorImpl<WktWrappers.WrapperRequiredString> {
        public void assertValid(WktWrappers.WrapperRequiredString proto, ValidatorIndex index) throws ValidationException {
            if (!proto.hasVal()) {
                throw new ValidationException("&{0xc0004d0900 .tests.harness.cases.WrapperRequiredString.val 0xc00017cc60 <nil> 0xc000013128 {0xc0004d7780}}", (Object)"null", "is required");
            }
            ConstantValidation.constant((String)".tests.harness.cases.WrapperRequiredString.val", (Object)proto.getVal().getValue(), (Object)"bar");
        }
    }

    public static class WrapperRequiredEmptyStringValidator
    implements ValidatorImpl<WktWrappers.WrapperRequiredEmptyString> {
        public void assertValid(WktWrappers.WrapperRequiredEmptyString proto, ValidatorIndex index) throws ValidationException {
            if (!proto.hasVal()) {
                throw new ValidationException("&{0xc0004d0980 .tests.harness.cases.WrapperRequiredEmptyString.val 0xc00017cd80 <nil> 0xc000013158 {0xc0004d7c00}}", (Object)"null", "is required");
            }
            ConstantValidation.constant((String)".tests.harness.cases.WrapperRequiredEmptyString.val", (Object)proto.getVal().getValue(), (Object)"");
        }
    }

    public static class WrapperOptionalUuidStringValidator
    implements ValidatorImpl<WktWrappers.WrapperOptionalUuidString> {
        public void assertValid(WktWrappers.WrapperOptionalUuidString proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasVal()) {
                StringValidation.uuid((String)".tests.harness.cases.WrapperOptionalUuidString.val", (String)proto.getVal().getValue());
            }
        }
    }

    public static class WrapperRequiredFloatValidator
    implements ValidatorImpl<WktWrappers.WrapperRequiredFloat> {
        private final Float VAL__GT = Float.valueOf(0.0f);

        public void assertValid(WktWrappers.WrapperRequiredFloat proto, ValidatorIndex index) throws ValidationException {
            if (!proto.hasVal()) {
                throw new ValidationException("&{0xc0004d0a80 .tests.harness.cases.WrapperRequiredFloat.val 0xc00017cfc0 <nil> 0xc000013248 {0xc0004d8580}}", (Object)"null", "is required");
            }
            ComparativeValidation.greaterThan((String)".tests.harness.cases.WrapperRequiredFloat.val", (Object)Float.valueOf(proto.getVal().getValue()), (Object)this.VAL__GT, Comparator.naturalOrder());
        }
    }
}

