/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.re2j.Pattern;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ConstantValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import tests.harness.cases.Strings;

public class StringsValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Strings.StringNone.class)) {
            return new StringNoneValidator();
        }
        if (clazz.equals(Strings.StringConst.class)) {
            return new StringConstValidator();
        }
        if (clazz.equals(Strings.StringIn.class)) {
            return new StringInValidator();
        }
        if (clazz.equals(Strings.StringNotIn.class)) {
            return new StringNotInValidator();
        }
        if (clazz.equals(Strings.StringLen.class)) {
            return new StringLenValidator();
        }
        if (clazz.equals(Strings.StringMinLen.class)) {
            return new StringMinLenValidator();
        }
        if (clazz.equals(Strings.StringMaxLen.class)) {
            return new StringMaxLenValidator();
        }
        if (clazz.equals(Strings.StringMinMaxLen.class)) {
            return new StringMinMaxLenValidator();
        }
        if (clazz.equals(Strings.StringEqualMinMaxLen.class)) {
            return new StringEqualMinMaxLenValidator();
        }
        if (clazz.equals(Strings.StringLenBytes.class)) {
            return new StringLenBytesValidator();
        }
        if (clazz.equals(Strings.StringMinBytes.class)) {
            return new StringMinBytesValidator();
        }
        if (clazz.equals(Strings.StringMaxBytes.class)) {
            return new StringMaxBytesValidator();
        }
        if (clazz.equals(Strings.StringMinMaxBytes.class)) {
            return new StringMinMaxBytesValidator();
        }
        if (clazz.equals(Strings.StringEqualMinMaxBytes.class)) {
            return new StringEqualMinMaxBytesValidator();
        }
        if (clazz.equals(Strings.StringPattern.class)) {
            return new StringPatternValidator();
        }
        if (clazz.equals(Strings.StringPatternEscapes.class)) {
            return new StringPatternEscapesValidator();
        }
        if (clazz.equals(Strings.StringPrefix.class)) {
            return new StringPrefixValidator();
        }
        if (clazz.equals(Strings.StringContains.class)) {
            return new StringContainsValidator();
        }
        if (clazz.equals(Strings.StringNotContains.class)) {
            return new StringNotContainsValidator();
        }
        if (clazz.equals(Strings.StringSuffix.class)) {
            return new StringSuffixValidator();
        }
        if (clazz.equals(Strings.StringEmail.class)) {
            return new StringEmailValidator();
        }
        if (clazz.equals(Strings.StringAddress.class)) {
            return new StringAddressValidator();
        }
        if (clazz.equals(Strings.StringHostname.class)) {
            return new StringHostnameValidator();
        }
        if (clazz.equals(Strings.StringIP.class)) {
            return new StringIPValidator();
        }
        if (clazz.equals(Strings.StringIPv4.class)) {
            return new StringIPv4Validator();
        }
        if (clazz.equals(Strings.StringIPv6.class)) {
            return new StringIPv6Validator();
        }
        if (clazz.equals(Strings.StringURI.class)) {
            return new StringURIValidator();
        }
        if (clazz.equals(Strings.StringURIRef.class)) {
            return new StringURIRefValidator();
        }
        if (clazz.equals(Strings.StringUUID.class)) {
            return new StringUUIDValidator();
        }
        if (clazz.equals(Strings.StringHttpHeaderName.class)) {
            return new StringHttpHeaderNameValidator();
        }
        if (clazz.equals(Strings.StringHttpHeaderValue.class)) {
            return new StringHttpHeaderValueValidator();
        }
        if (clazz.equals(Strings.StringValidHeader.class)) {
            return new StringValidHeaderValidator();
        }
        if (clazz.equals(Strings.StringUUIDIgnore.class)) {
            return new StringUUIDIgnoreValidator();
        }
        if (clazz.equals(Strings.StringInOneOf.class)) {
            return new StringInOneOfValidator();
        }
        return null;
    }

    public static class StringNoneValidator
    implements ValidatorImpl<Strings.StringNone> {
        public void assertValid(Strings.StringNone proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class StringConstValidator
    implements ValidatorImpl<Strings.StringConst> {
        public void assertValid(Strings.StringConst proto, ValidatorIndex index) throws ValidationException {
            ConstantValidation.constant((String)".tests.harness.cases.StringConst.val", (Object)proto.getVal(), (Object)"foo");
        }
    }

    public static class StringInValidator
    implements ValidatorImpl<Strings.StringIn> {
        private final String[] VAL__IN = new String[]{"bar", "baz"};

        public void assertValid(Strings.StringIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.in((String)".tests.harness.cases.StringIn.val", (Object)proto.getVal(), (Object[])this.VAL__IN);
        }
    }

    public static class StringNotInValidator
    implements ValidatorImpl<Strings.StringNotIn> {
        private final String[] VAL__NOT_IN = new String[]{"fizz", "buzz"};

        public void assertValid(Strings.StringNotIn proto, ValidatorIndex index) throws ValidationException {
            CollectiveValidation.notIn((String)".tests.harness.cases.StringNotIn.val", (Object)proto.getVal(), (Object[])this.VAL__NOT_IN);
        }
    }

    public static class StringLenValidator
    implements ValidatorImpl<Strings.StringLen> {
        public void assertValid(Strings.StringLen proto, ValidatorIndex index) throws ValidationException {
            StringValidation.length((String)".tests.harness.cases.StringLen.val", (String)proto.getVal(), (int)3);
        }
    }

    public static class StringMinLenValidator
    implements ValidatorImpl<Strings.StringMinLen> {
        public void assertValid(Strings.StringMinLen proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".tests.harness.cases.StringMinLen.val", (String)proto.getVal(), (int)3);
        }
    }

    public static class StringMaxLenValidator
    implements ValidatorImpl<Strings.StringMaxLen> {
        public void assertValid(Strings.StringMaxLen proto, ValidatorIndex index) throws ValidationException {
            StringValidation.maxLength((String)".tests.harness.cases.StringMaxLen.val", (String)proto.getVal(), (int)5);
        }
    }

    public static class StringMinMaxLenValidator
    implements ValidatorImpl<Strings.StringMinMaxLen> {
        public void assertValid(Strings.StringMinMaxLen proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".tests.harness.cases.StringMinMaxLen.val", (String)proto.getVal(), (int)3);
            StringValidation.maxLength((String)".tests.harness.cases.StringMinMaxLen.val", (String)proto.getVal(), (int)5);
        }
    }

    public static class StringEqualMinMaxLenValidator
    implements ValidatorImpl<Strings.StringEqualMinMaxLen> {
        public void assertValid(Strings.StringEqualMinMaxLen proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".tests.harness.cases.StringEqualMinMaxLen.val", (String)proto.getVal(), (int)5);
            StringValidation.maxLength((String)".tests.harness.cases.StringEqualMinMaxLen.val", (String)proto.getVal(), (int)5);
        }
    }

    public static class StringLenBytesValidator
    implements ValidatorImpl<Strings.StringLenBytes> {
        public void assertValid(Strings.StringLenBytes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.lenBytes((String)".tests.harness.cases.StringLenBytes.val", (String)proto.getVal(), (int)4);
        }
    }

    public static class StringMinBytesValidator
    implements ValidatorImpl<Strings.StringMinBytes> {
        public void assertValid(Strings.StringMinBytes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minBytes((String)".tests.harness.cases.StringMinBytes.val", (String)proto.getVal(), (int)4);
        }
    }

    public static class StringMaxBytesValidator
    implements ValidatorImpl<Strings.StringMaxBytes> {
        public void assertValid(Strings.StringMaxBytes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.maxBytes((String)".tests.harness.cases.StringMaxBytes.val", (String)proto.getVal(), (int)8);
        }
    }

    public static class StringMinMaxBytesValidator
    implements ValidatorImpl<Strings.StringMinMaxBytes> {
        public void assertValid(Strings.StringMinMaxBytes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minBytes((String)".tests.harness.cases.StringMinMaxBytes.val", (String)proto.getVal(), (int)4);
            StringValidation.maxBytes((String)".tests.harness.cases.StringMinMaxBytes.val", (String)proto.getVal(), (int)8);
        }
    }

    public static class StringEqualMinMaxBytesValidator
    implements ValidatorImpl<Strings.StringEqualMinMaxBytes> {
        public void assertValid(Strings.StringEqualMinMaxBytes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minBytes((String)".tests.harness.cases.StringEqualMinMaxBytes.val", (String)proto.getVal(), (int)4);
            StringValidation.maxBytes((String)".tests.harness.cases.StringEqualMinMaxBytes.val", (String)proto.getVal(), (int)8);
        }
    }

    public static class StringPatternValidator
    implements ValidatorImpl<Strings.StringPattern> {
        Pattern VAL__PATTERN = Pattern.compile((String)"(?i)^[a-z0-9]+$");

        public void assertValid(Strings.StringPattern proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".tests.harness.cases.StringPattern.val", (String)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class StringPatternEscapesValidator
    implements ValidatorImpl<Strings.StringPatternEscapes> {
        Pattern VAL__PATTERN = Pattern.compile((String)"\\* \\\\ \\w");

        public void assertValid(Strings.StringPatternEscapes proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".tests.harness.cases.StringPatternEscapes.val", (String)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class StringPrefixValidator
    implements ValidatorImpl<Strings.StringPrefix> {
        public void assertValid(Strings.StringPrefix proto, ValidatorIndex index) throws ValidationException {
            StringValidation.prefix((String)".tests.harness.cases.StringPrefix.val", (String)proto.getVal(), (String)"foo");
        }
    }

    public static class StringContainsValidator
    implements ValidatorImpl<Strings.StringContains> {
        public void assertValid(Strings.StringContains proto, ValidatorIndex index) throws ValidationException {
            StringValidation.contains((String)".tests.harness.cases.StringContains.val", (String)proto.getVal(), (String)"bar");
        }
    }

    public static class StringNotContainsValidator
    implements ValidatorImpl<Strings.StringNotContains> {
        public void assertValid(Strings.StringNotContains proto, ValidatorIndex index) throws ValidationException {
            StringValidation.notContains((String)".tests.harness.cases.StringNotContains.val", (String)proto.getVal(), (String)"bar");
        }
    }

    public static class StringSuffixValidator
    implements ValidatorImpl<Strings.StringSuffix> {
        public void assertValid(Strings.StringSuffix proto, ValidatorIndex index) throws ValidationException {
            StringValidation.suffix((String)".tests.harness.cases.StringSuffix.val", (String)proto.getVal(), (String)"baz");
        }
    }

    public static class StringEmailValidator
    implements ValidatorImpl<Strings.StringEmail> {
        public void assertValid(Strings.StringEmail proto, ValidatorIndex index) throws ValidationException {
            StringValidation.email((String)".tests.harness.cases.StringEmail.val", (String)proto.getVal());
        }
    }

    public static class StringAddressValidator
    implements ValidatorImpl<Strings.StringAddress> {
        public void assertValid(Strings.StringAddress proto, ValidatorIndex index) throws ValidationException {
            StringValidation.address((String)".tests.harness.cases.StringAddress.val", (String)proto.getVal());
        }
    }

    public static class StringHostnameValidator
    implements ValidatorImpl<Strings.StringHostname> {
        public void assertValid(Strings.StringHostname proto, ValidatorIndex index) throws ValidationException {
            StringValidation.hostName((String)".tests.harness.cases.StringHostname.val", (String)proto.getVal());
        }
    }

    public static class StringIPValidator
    implements ValidatorImpl<Strings.StringIP> {
        public void assertValid(Strings.StringIP proto, ValidatorIndex index) throws ValidationException {
            StringValidation.ip((String)".tests.harness.cases.StringIP.val", (String)proto.getVal());
        }
    }

    public static class StringIPv4Validator
    implements ValidatorImpl<Strings.StringIPv4> {
        public void assertValid(Strings.StringIPv4 proto, ValidatorIndex index) throws ValidationException {
            StringValidation.ipv4((String)".tests.harness.cases.StringIPv4.val", (String)proto.getVal());
        }
    }

    public static class StringIPv6Validator
    implements ValidatorImpl<Strings.StringIPv6> {
        public void assertValid(Strings.StringIPv6 proto, ValidatorIndex index) throws ValidationException {
            StringValidation.ipv6((String)".tests.harness.cases.StringIPv6.val", (String)proto.getVal());
        }
    }

    public static class StringURIValidator
    implements ValidatorImpl<Strings.StringURI> {
        public void assertValid(Strings.StringURI proto, ValidatorIndex index) throws ValidationException {
            StringValidation.uri((String)".tests.harness.cases.StringURI.val", (String)proto.getVal());
        }
    }

    public static class StringURIRefValidator
    implements ValidatorImpl<Strings.StringURIRef> {
        public void assertValid(Strings.StringURIRef proto, ValidatorIndex index) throws ValidationException {
            StringValidation.uriRef((String)".tests.harness.cases.StringURIRef.val", (String)proto.getVal());
        }
    }

    public static class StringUUIDValidator
    implements ValidatorImpl<Strings.StringUUID> {
        public void assertValid(Strings.StringUUID proto, ValidatorIndex index) throws ValidationException {
            StringValidation.uuid((String)".tests.harness.cases.StringUUID.val", (String)proto.getVal());
        }
    }

    public static class StringHttpHeaderNameValidator
    implements ValidatorImpl<Strings.StringHttpHeaderName> {
        Pattern VAL__PATTERN = Pattern.compile((String)"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$");

        public void assertValid(Strings.StringHttpHeaderName proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".tests.harness.cases.StringHttpHeaderName.val", (String)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class StringHttpHeaderValueValidator
    implements ValidatorImpl<Strings.StringHttpHeaderValue> {
        Pattern VAL__PATTERN = Pattern.compile((String)"^[^\\x00-\b\n-\\x1f\\x7f]*$");

        public void assertValid(Strings.StringHttpHeaderValue proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".tests.harness.cases.StringHttpHeaderValue.val", (String)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class StringValidHeaderValidator
    implements ValidatorImpl<Strings.StringValidHeader> {
        Pattern VAL__PATTERN = Pattern.compile((String)"^[^\\x00\n\r]*$");

        public void assertValid(Strings.StringValidHeader proto, ValidatorIndex index) throws ValidationException {
            StringValidation.pattern((String)".tests.harness.cases.StringValidHeader.val", (String)proto.getVal(), (Pattern)this.VAL__PATTERN);
        }
    }

    public static class StringUUIDIgnoreValidator
    implements ValidatorImpl<Strings.StringUUIDIgnore> {
        public void assertValid(Strings.StringUUIDIgnore proto, ValidatorIndex index) throws ValidationException {
            if (!proto.getVal().isEmpty()) {
                StringValidation.uuid((String)".tests.harness.cases.StringUUIDIgnore.val", (String)proto.getVal());
            }
        }
    }

    public static class StringInOneOfValidator
    implements ValidatorImpl<Strings.StringInOneOf> {
        private final String[] BAR__IN = new String[]{"a", "b"};

        public void assertValid(Strings.StringInOneOf proto, ValidatorIndex index) throws ValidationException {
            switch (proto.getFooCase()) {
                case BAR: {
                    CollectiveValidation.in((String)".tests.harness.cases.StringInOneOf.bar", (Object)proto.getBar(), (Object[])this.BAR__IN);
                }
            }
        }
    }
}

