/*
 * Decompiled with CFR 0.152.
 */
package tests.harness.cases;

import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.re2j.Pattern;
import io.envoyproxy.pgv.CollectiveValidation;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.TimestampValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import java.util.List;
import tests.harness.cases.Repeated;

public class RepeatedValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(Repeated.Embed.class)) {
            return new EmbedValidator();
        }
        if (clazz.equals(Repeated.RepeatedNone.class)) {
            return new RepeatedNoneValidator();
        }
        if (clazz.equals(Repeated.RepeatedEmbedNone.class)) {
            return new RepeatedEmbedNoneValidator();
        }
        if (clazz.equals(Repeated.RepeatedEmbedCrossPackageNone.class)) {
            return new RepeatedEmbedCrossPackageNoneValidator();
        }
        if (clazz.equals(Repeated.RepeatedMin.class)) {
            return new RepeatedMinValidator();
        }
        if (clazz.equals(Repeated.RepeatedMax.class)) {
            return new RepeatedMaxValidator();
        }
        if (clazz.equals(Repeated.RepeatedMinMax.class)) {
            return new RepeatedMinMaxValidator();
        }
        if (clazz.equals(Repeated.RepeatedExact.class)) {
            return new RepeatedExactValidator();
        }
        if (clazz.equals(Repeated.RepeatedUnique.class)) {
            return new RepeatedUniqueValidator();
        }
        if (clazz.equals(Repeated.RepeatedItemRule.class)) {
            return new RepeatedItemRuleValidator();
        }
        if (clazz.equals(Repeated.RepeatedItemPattern.class)) {
            return new RepeatedItemPatternValidator();
        }
        if (clazz.equals(Repeated.RepeatedEmbedSkip.class)) {
            return new RepeatedEmbedSkipValidator();
        }
        if (clazz.equals(Repeated.RepeatedItemIn.class)) {
            return new RepeatedItemInValidator();
        }
        if (clazz.equals(Repeated.RepeatedItemNotIn.class)) {
            return new RepeatedItemNotInValidator();
        }
        if (clazz.equals(Repeated.RepeatedEnumIn.class)) {
            return new RepeatedEnumInValidator();
        }
        if (clazz.equals(Repeated.RepeatedEnumNotIn.class)) {
            return new RepeatedEnumNotInValidator();
        }
        if (clazz.equals(Repeated.RepeatedEmbeddedEnumIn.class)) {
            return new RepeatedEmbeddedEnumInValidator();
        }
        if (clazz.equals(Repeated.RepeatedEmbeddedEnumNotIn.class)) {
            return new RepeatedEmbeddedEnumNotInValidator();
        }
        if (clazz.equals(Repeated.RepeatedAnyIn.class)) {
            return new RepeatedAnyInValidator();
        }
        if (clazz.equals(Repeated.RepeatedAnyNotIn.class)) {
            return new RepeatedAnyNotInValidator();
        }
        if (clazz.equals(Repeated.RepeatedMinAndItemLen.class)) {
            return new RepeatedMinAndItemLenValidator();
        }
        if (clazz.equals(Repeated.RepeatedMinAndMaxItemLen.class)) {
            return new RepeatedMinAndMaxItemLenValidator();
        }
        if (clazz.equals(Repeated.RepeatedDuration.class)) {
            return new RepeatedDurationValidator();
        }
        if (clazz.equals(Repeated.RepeatedExactIgnore.class)) {
            return new RepeatedExactIgnoreValidator();
        }
        return null;
    }

    public static class EmbedValidator
    implements ValidatorImpl<Repeated.Embed> {
        private final Long VAL__GT = 0L;

        public void assertValid(Repeated.Embed proto, ValidatorIndex index) throws ValidationException {
            ComparativeValidation.greaterThan((String)".tests.harness.cases.Embed.val", (Object)proto.getVal(), (Object)this.VAL__GT, Comparator.naturalOrder());
        }
    }

    public static class RepeatedNoneValidator
    implements ValidatorImpl<Repeated.RepeatedNone> {
        public void assertValid(Repeated.RepeatedNone proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> {});
        }
    }

    public static class RepeatedEmbedNoneValidator
    implements ValidatorImpl<Repeated.RepeatedEmbedNone> {
        public void assertValid(Repeated.RepeatedEmbedNone proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class RepeatedEmbedCrossPackageNoneValidator
    implements ValidatorImpl<Repeated.RepeatedEmbedCrossPackageNone> {
        public void assertValid(Repeated.RepeatedEmbedCrossPackageNone proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class RepeatedMinValidator
    implements ValidatorImpl<Repeated.RepeatedMin> {
        public void assertValid(Repeated.RepeatedMin proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedMin.val", proto.getValList(), (int)2);
            RepeatedValidation.forEach(proto.getValList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class RepeatedMaxValidator
    implements ValidatorImpl<Repeated.RepeatedMax> {
        public void assertValid(Repeated.RepeatedMax proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.maxItems((String)".tests.harness.cases.RepeatedMax.val", proto.getValList(), (int)3);
            RepeatedValidation.forEach(proto.getValList(), item -> {});
        }
    }

    public static class RepeatedMinMaxValidator
    implements ValidatorImpl<Repeated.RepeatedMinMax> {
        public void assertValid(Repeated.RepeatedMinMax proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedMinMax.val", proto.getValList(), (int)2);
            RepeatedValidation.maxItems((String)".tests.harness.cases.RepeatedMinMax.val", proto.getValList(), (int)4);
            RepeatedValidation.forEach(proto.getValList(), item -> {});
        }
    }

    public static class RepeatedExactValidator
    implements ValidatorImpl<Repeated.RepeatedExact> {
        public void assertValid(Repeated.RepeatedExact proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedExact.val", proto.getValList(), (int)3);
            RepeatedValidation.maxItems((String)".tests.harness.cases.RepeatedExact.val", proto.getValList(), (int)3);
            RepeatedValidation.forEach(proto.getValList(), item -> {});
        }
    }

    public static class RepeatedUniqueValidator
    implements ValidatorImpl<Repeated.RepeatedUnique> {
        public void assertValid(Repeated.RepeatedUnique proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.unique((String)".tests.harness.cases.RepeatedUnique.val", (List)proto.getValList());
            RepeatedValidation.forEach((List)proto.getValList(), item -> {});
        }
    }

    public static class RepeatedItemRuleValidator
    implements ValidatorImpl<Repeated.RepeatedItemRule> {
        private final Float VAL__GT = Float.valueOf(0.0f);

        public void assertValid(Repeated.RepeatedItemRule proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> ComparativeValidation.greaterThan((String)".tests.harness.cases.RepeatedItemRule.val", (Object)item, (Object)this.VAL__GT, Comparator.naturalOrder()));
        }
    }

    public static class RepeatedItemPatternValidator
    implements ValidatorImpl<Repeated.RepeatedItemPattern> {
        Pattern VAL__PATTERN = Pattern.compile((String)"(?i)^[a-z0-9]+$");

        public void assertValid(Repeated.RepeatedItemPattern proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getValList(), item -> StringValidation.pattern((String)".tests.harness.cases.RepeatedItemPattern.val", (String)item, (Pattern)this.VAL__PATTERN));
        }
    }

    public static class RepeatedEmbedSkipValidator
    implements ValidatorImpl<Repeated.RepeatedEmbedSkip> {
        public void assertValid(Repeated.RepeatedEmbedSkip proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> {});
        }
    }

    public static class RepeatedItemInValidator
    implements ValidatorImpl<Repeated.RepeatedItemIn> {
        private final String[] VAL__IN = new String[]{"foo", "bar"};

        public void assertValid(Repeated.RepeatedItemIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getValList(), item -> CollectiveValidation.in((String)".tests.harness.cases.RepeatedItemIn.val", (Object)item, (Object[])this.VAL__IN));
        }
    }

    public static class RepeatedItemNotInValidator
    implements ValidatorImpl<Repeated.RepeatedItemNotIn> {
        private final String[] VAL__NOT_IN = new String[]{"foo", "bar"};

        public void assertValid(Repeated.RepeatedItemNotIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach((List)proto.getValList(), item -> CollectiveValidation.notIn((String)".tests.harness.cases.RepeatedItemNotIn.val", (Object)item, (Object[])this.VAL__NOT_IN));
        }
    }

    public static class RepeatedEnumInValidator
    implements ValidatorImpl<Repeated.RepeatedEnumIn> {
        private final Repeated.AnEnum[] VAL__IN = new Repeated.AnEnum[]{Repeated.AnEnum.forNumber(0)};

        public void assertValid(Repeated.RepeatedEnumIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.in((String)".tests.harness.cases.RepeatedEnumIn.val", (Object)item, (Object[])this.VAL__IN));
        }
    }

    public static class RepeatedEnumNotInValidator
    implements ValidatorImpl<Repeated.RepeatedEnumNotIn> {
        private final Repeated.AnEnum[] VAL__NOT_IN = new Repeated.AnEnum[]{Repeated.AnEnum.forNumber(0)};

        public void assertValid(Repeated.RepeatedEnumNotIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.notIn((String)".tests.harness.cases.RepeatedEnumNotIn.val", (Object)item, (Object[])this.VAL__NOT_IN));
        }
    }

    public static class RepeatedEmbeddedEnumInValidator
    implements ValidatorImpl<Repeated.RepeatedEmbeddedEnumIn> {
        private final Repeated.RepeatedEmbeddedEnumIn.AnotherInEnum[] VAL__IN = new Repeated.RepeatedEmbeddedEnumIn.AnotherInEnum[]{Repeated.RepeatedEmbeddedEnumIn.AnotherInEnum.forNumber(0)};

        public void assertValid(Repeated.RepeatedEmbeddedEnumIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.in((String)".tests.harness.cases.RepeatedEmbeddedEnumIn.val", (Object)item, (Object[])this.VAL__IN));
        }
    }

    public static class RepeatedEmbeddedEnumNotInValidator
    implements ValidatorImpl<Repeated.RepeatedEmbeddedEnumNotIn> {
        private final Repeated.RepeatedEmbeddedEnumNotIn.AnotherNotInEnum[] VAL__NOT_IN = new Repeated.RepeatedEmbeddedEnumNotIn.AnotherNotInEnum[]{Repeated.RepeatedEmbeddedEnumNotIn.AnotherNotInEnum.forNumber(0)};

        public void assertValid(Repeated.RepeatedEmbeddedEnumNotIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.notIn((String)".tests.harness.cases.RepeatedEmbeddedEnumNotIn.val", (Object)item, (Object[])this.VAL__NOT_IN));
        }
    }

    public static class RepeatedAnyInValidator
    implements ValidatorImpl<Repeated.RepeatedAnyIn> {
        private final String[] VAL__IN = new String[]{"type.googleapis.com/google.protobuf.Duration"};

        public void assertValid(Repeated.RepeatedAnyIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.in((String)".tests.harness.cases.RepeatedAnyIn.val", (Object)item.getTypeUrl(), (Object[])this.VAL__IN));
        }
    }

    public static class RepeatedAnyNotInValidator
    implements ValidatorImpl<Repeated.RepeatedAnyNotIn> {
        private final String[] VAL__NOT_IN = new String[]{"type.googleapis.com/google.protobuf.Timestamp"};

        public void assertValid(Repeated.RepeatedAnyNotIn proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> CollectiveValidation.notIn((String)".tests.harness.cases.RepeatedAnyNotIn.val", (Object)item.getTypeUrl(), (Object[])this.VAL__NOT_IN));
        }
    }

    public static class RepeatedMinAndItemLenValidator
    implements ValidatorImpl<Repeated.RepeatedMinAndItemLen> {
        public void assertValid(Repeated.RepeatedMinAndItemLen proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedMinAndItemLen.val", (List)proto.getValList(), (int)1);
            RepeatedValidation.forEach((List)proto.getValList(), item -> StringValidation.length((String)".tests.harness.cases.RepeatedMinAndItemLen.val", (String)item, (int)3));
        }
    }

    public static class RepeatedMinAndMaxItemLenValidator
    implements ValidatorImpl<Repeated.RepeatedMinAndMaxItemLen> {
        public void assertValid(Repeated.RepeatedMinAndMaxItemLen proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedMinAndMaxItemLen.val", (List)proto.getValList(), (int)1);
            RepeatedValidation.maxItems((String)".tests.harness.cases.RepeatedMinAndMaxItemLen.val", (List)proto.getValList(), (int)3);
            RepeatedValidation.forEach((List)proto.getValList(), item -> {});
        }
    }

    public static class RepeatedDurationValidator
    implements ValidatorImpl<Repeated.RepeatedDuration> {
        private final Duration VAL__GTE = TimestampValidation.toDuration((long)0L, (long)1000000L);

        public void assertValid(Repeated.RepeatedDuration proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getValList(), item -> ComparativeValidation.greaterThanOrEqual((String)".tests.harness.cases.RepeatedDuration.val", (Object)item, (Object)this.VAL__GTE, (Comparator)Durations.comparator()));
        }
    }

    public static class RepeatedExactIgnoreValidator
    implements ValidatorImpl<Repeated.RepeatedExactIgnore> {
        public void assertValid(Repeated.RepeatedExactIgnore proto, ValidatorIndex index) throws ValidationException {
            if (!proto.getValList().isEmpty()) {
                RepeatedValidation.minItems((String)".tests.harness.cases.RepeatedExactIgnore.val", proto.getValList(), (int)3);
                RepeatedValidation.maxItems((String)".tests.harness.cases.RepeatedExactIgnore.val", proto.getValList(), (int)3);
                RepeatedValidation.forEach(proto.getValList(), item -> {});
            }
        }
    }
}

