/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.pgv.grpc;

import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorIndex;
import io.envoyproxy.pgv.grpc.ValidationExceptions;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusRuntimeException;

public class ValidatingServerInterceptor
implements ServerInterceptor {
    private final ValidatorIndex index;

    public ValidatingServerInterceptor(ValidatorIndex index) {
        this.index = index;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){
            private boolean aborted;
            {
                super(arg0);
                this.aborted = false;
            }

            public void onMessage(ReqT message) {
                try {
                    ValidatingServerInterceptor.this.index.validatorFor(message.getClass()).assertValid(message);
                    super.onMessage(message);
                }
                catch (ValidationException ex) {
                    StatusRuntimeException status = ValidationExceptions.asStatusRuntimeException(ex);
                    this.aborted = true;
                    call.close(status.getStatus(), status.getTrailers());
                }
            }

            public void onHalfClose() {
                if (!this.aborted) {
                    super.onHalfClose();
                }
            }
        };
    }
}

