/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.TargetError;
import bsh.This;
import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import java.util.Vector;

public class BeanShellBSFEngine
extends BSFEngineImpl {
    Interpreter interpreter;
    boolean installedApplyMethod;
    static final String bsfApplyMethod = "_bsfApply( _bsfNames, _bsfArgs, _bsfText ) {for(i=0;i<_bsfNames.length;i++)this.namespace.setVariable(_bsfNames[i], _bsfArgs[i]);return this.interpreter.eval(_bsfText, this.namespace);}";

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.interpreter = new Interpreter();
        try {
            this.interpreter.set("bsf", (Object)bSFManager);
        }
        catch (EvalError evalError) {
            throw new BSFException("bsh internal error: " + evalError.toString());
        }
        int n = 0;
        while (n < vector.size()) {
            BSFDeclaredBean bSFDeclaredBean = (BSFDeclaredBean)vector.get(n);
            this.declareBean(bSFDeclaredBean);
            ++n;
        }
    }

    public void setDebug(boolean bl) {
        Interpreter.DEBUG = bl;
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        if (object == null) {
            try {
                object = this.interpreter.get("global");
            }
            catch (EvalError evalError) {
                throw new BSFException("bsh internal error: " + evalError.toString());
            }
        }
        if (object instanceof This) {
            try {
                return ((This)object).invokeMethod(string, objectArray);
            }
            catch (InterpreterError interpreterError) {
                throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)interpreterError));
            }
            catch (TargetError targetError) {
                throw new BSFException("The application script threw an exception: " + targetError.getTarget());
            }
            catch (EvalError evalError) {
                throw new BSFException("BeanShell script error: " + (Object)((Object)evalError));
            }
        }
        throw new BSFException("Cannot invoke method: " + string + ". Object: " + object + " is not a BeanShell scripted object.");
    }

    public Object apply(String string, int n, int n2, Object object, Vector vector, Vector vector2) throws BSFException {
        if (vector.size() != vector2.size()) {
            throw new BSFException("number of params/names mismatch");
        }
        if (!(object instanceof String)) {
            throw new BSFException("apply: functino body must be a string");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Object[] objectArray2 = new String[vector2.size()];
        vector2.copyInto(objectArray2);
        try {
            if (!this.installedApplyMethod) {
                this.interpreter.eval(bsfApplyMethod);
                this.installedApplyMethod = true;
            }
            This this_ = (This)this.interpreter.get("global");
            return this_.invokeMethod("_bsfApply", new Object[]{objectArray, objectArray2, (String)object});
        }
        catch (InterpreterError interpreterError) {
            throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)interpreterError) + this.sourceInfo(string, n, n2));
        }
        catch (TargetError targetError) {
            throw new BSFException("The application script threw an exception: " + targetError.getTarget() + this.sourceInfo(string, n, n2));
        }
        catch (EvalError evalError) {
            throw new BSFException("BeanShell script error: " + (Object)((Object)evalError) + this.sourceInfo(string, n, n2));
        }
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        if (!(object instanceof String)) {
            throw new BSFException("BeanShell expression must be a string");
        }
        try {
            return this.interpreter.eval((String)object);
        }
        catch (InterpreterError interpreterError) {
            throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)interpreterError) + this.sourceInfo(string, n, n2));
        }
        catch (TargetError targetError) {
            throw new BSFException("The application script threw an exception: " + targetError.getTarget() + this.sourceInfo(string, n, n2));
        }
        catch (EvalError evalError) {
            throw new BSFException("BeanShell script error: " + (Object)((Object)evalError) + this.sourceInfo(string, n, n2));
        }
    }

    public void exec(String string, int n, int n2, Object object) throws BSFException {
        this.eval(string, n, n2, object);
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        try {
            this.interpreter.set(bSFDeclaredBean.name, bSFDeclaredBean.bean);
        }
        catch (EvalError evalError) {
            throw new BSFException("error declaring bean: " + bSFDeclaredBean.name + " : " + evalError.toString());
        }
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
        try {
            this.interpreter.unset(bSFDeclaredBean.name);
        }
        catch (EvalError evalError) {
            throw new BSFException("bsh internal error: " + evalError.toString());
        }
    }

    public void terminate() {
    }

    private String sourceInfo(String string, int n, int n2) {
        return " BSF info: " + string + " at line: " + n + " column: columnNo";
    }
}

