/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi.util;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.Requirement;
import br.eti.kinoshita.testlinkjavaapi.model.Role;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStep;
import br.eti.kinoshita.testlinkjavaapi.model.TestCaseStepResult;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import br.eti.kinoshita.testlinkjavaapi.model.User;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());

    private Util() {
    }

    public static Map<String, Object> getTestProjectMap(TestProject project) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_PROJECT_NAME.toString(), project.getName());
        executionData.put(TestLinkParams.TEST_CASE_PREFIX.toString(), project.getPrefix());
        executionData.put(TestLinkParams.NOTES.toString(), project.getNotes());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put(TestLinkParams.ENABLE_REQUIREMENTS.toString(), project.isEnableRequirements());
        options.put(TestLinkParams.ENABLE_TEST_PRIORITY.toString(), project.isEnableTestPriority());
        options.put(TestLinkParams.ENABLE_AUTOMATION.toString(), project.isEnableAutomation());
        options.put(TestLinkParams.ENABLE_INVENTORY.toString(), project.isEnableInventory());
        executionData.put(TestLinkParams.OPTIONS.toString(), options);
        executionData.put(TestLinkParams.ACTIVE.toString(), project.isActive());
        executionData.put(TestLinkParams.PUBLIC.toString(), project.isPublic());
        return executionData;
    }

    public static TestProject getTestProject(Map<String, Object> map) {
        int id;
        Object o;
        TestProject testProject = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            testProject = new TestProject();
            testProject.setId(id);
            testProject.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            testProject.setPrefix(Util.getString(map, TestLinkResponseParams.PREFIX.toString()));
            testProject.setNotes(Util.getString(map, TestLinkResponseParams.NOTES.toString()));
            Map optMap = (Map)map.get(TestLinkResponseParams.OPT.toString());
            testProject.setEnableAutomation(Util.getBoolean(optMap, TestLinkResponseParams.AUTOMATION_ENABLED.toString()));
            testProject.setEnableRequirements(Util.getBoolean(optMap, TestLinkResponseParams.REQUIREMENTS_ENABLED.toString()));
            testProject.setEnableTestPriority(Util.getBoolean(optMap, TestLinkResponseParams.TEST_PRIORITY_ENABLED.toString()));
            testProject.setEnableInventory(Util.getBoolean(optMap, TestLinkResponseParams.INVENTORY_ENABLED.toString()));
            testProject.setActive(Util.getBoolean(map, TestLinkResponseParams.ACTIVE.toString()));
            testProject.setPublic(Util.getBoolean(map, TestLinkResponseParams.IS_PUBLIC.toString()));
        }
        return testProject;
    }

    public static Boolean getBoolean(Map<String, Object> map, String key) {
        Boolean booleanObj = null;
        Integer integer = Util.getInteger(map, key);
        if (integer != null) {
            booleanObj = integer == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return booleanObj;
    }

    public static String getString(Map<String, Object> map, String key) {
        Object o;
        String string = null;
        if (map != null && map.size() > 0 && (o = map.get(key)) != null) {
            string = o.toString();
        }
        return string;
    }

    public static Integer getInteger(Map<String, Object> map, String key) {
        Object o;
        Integer integer = null;
        if (map != null && map.size() > 0 && (o = map.get(key)) != null) {
            try {
                integer = Integer.parseInt(o.toString());
            }
            catch (NumberFormatException nfe) {
                integer = null;
            }
        }
        return integer;
    }

    public static Map<String, Object> getTestPlanMap(TestPlan plan) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_PLAN_NAME.toString(), plan.getName());
        executionData.put(TestLinkParams.TEST_PROJECT_NAME.toString(), plan.getProjectName());
        executionData.put(TestLinkParams.NOTES.toString(), plan.getNotes());
        executionData.put(TestLinkParams.ACTIVE.toString(), plan.isActive());
        executionData.put(TestLinkParams.PUBLIC.toString(), plan.isPublic());
        return executionData;
    }

    public static TestPlan getTestPlan(Map<String, Object> map) {
        int id;
        Object o;
        TestPlan testPlan = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            testPlan = new TestPlan();
            testPlan.setId(id);
            testPlan.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            testPlan.setProjectName(Util.getString(map, TestLinkResponseParams.PROJECT_NAME.toString()));
            testPlan.setNotes(Util.getString(map, TestLinkResponseParams.NOTES.toString()));
            testPlan.setActive(Util.getBoolean(map, TestLinkResponseParams.ACTIVE.toString()));
            testPlan.setPublic(Util.getBoolean(map, TestLinkResponseParams.IS_PUBLIC.toString()));
        }
        return testPlan;
    }

    public static Platform getPlatform(Map<String, Object> map) {
        int id;
        Object o;
        Platform platform = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            platform = new Platform();
            platform.setId(id);
            platform.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            platform.setNotes(Util.getString(map, TestLinkResponseParams.NOTES.toString()));
        }
        return platform;
    }

    public static Map<String, Object> getTestCaseMap(TestCase testCase) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        Util.putIfNotNull(executionData, TestLinkParams.TEST_CASE_NAME.toString(), testCase.getName());
        Util.putIfNotNull(executionData, TestLinkParams.TEST_CASE_ID.toString(), testCase.getId());
        Util.putIfNotNull(executionData, TestLinkParams.TEST_SUITE_ID.toString(), testCase.getTestSuiteId());
        Util.putIfNotNull(executionData, TestLinkParams.TEST_PROJECT_ID.toString(), testCase.getTestProjectId());
        Util.putIfNotNull(executionData, TestLinkParams.AUTHOR_LOGIN.toString(), testCase.getAuthorLogin());
        Util.putIfNotNull(executionData, TestLinkParams.SUMMARY.toString(), testCase.getSummary());
        if (testCase.getSteps() != null) {
            List<Map<String, Object>> steps = Util.getTestCaseStepsMap(testCase.getSteps());
            executionData.put(TestLinkParams.STEPS.toString(), steps);
        }
        Util.putIfNotNull(executionData, TestLinkParams.PRECONDITIONS.toString(), testCase.getPreconditions());
        Util.putIfNotNull(executionData, TestLinkParams.STATUS.toString(), Util.getStringValueOrNull((Object)testCase.getTestCaseStatus()));
        Util.putIfNotNull(executionData, TestLinkParams.IMPORTANCE.toString(), Util.getStringValueOrNull((Object)testCase.getTestImportance()));
        Util.putIfNotNull(executionData, TestLinkParams.EXECUTION_TYPE.toString(), Util.getStringValueOrNull((Object)testCase.getExecutionType()));
        Util.putIfNotNull(executionData, TestLinkParams.ORDER.toString(), testCase.getOrder());
        Util.putIfNotNull(executionData, TestLinkParams.INTERNAL_ID.toString(), testCase.getInternalId());
        Util.putIfNotNull(executionData, TestLinkParams.CHECK_DUPLICATED_NAME.toString(), testCase.getCheckDuplicatedName());
        Util.putIfNotNull(executionData, TestLinkParams.ACTION_ON_DUPLICATED_NAME.toString(), testCase.getActionOnDuplicatedName() != null ? testCase.getActionOnDuplicatedName().toString() : null);
        return executionData;
    }

    public static List<Map<String, Object>> getTestCaseStepsMap(List<TestCaseStep> testCaseSteps) {
        ArrayList<Map<String, Object>> steps = new ArrayList<Map<String, Object>>();
        if (testCaseSteps != null && testCaseSteps.size() > 0) {
            for (TestCaseStep testCaseStep : testCaseSteps) {
                Map<String, Object> testCaseStepMap = Util.getTestCaseStepMap(testCaseStep, true);
                steps.add(testCaseStepMap);
            }
        }
        return steps;
    }

    public static List<Integer> getTestCaseStepsIdList(List<TestCaseStep> testCaseSteps) {
        ArrayList<Integer> steps = new ArrayList<Integer>();
        if (testCaseSteps != null && testCaseSteps.size() > 0) {
            for (TestCaseStep testCaseStep : testCaseSteps) {
                steps.add(testCaseStep.getNumber());
            }
        }
        return steps;
    }

    public static TestCaseStep getTestCaseStep(Map<String, Object> map) {
        int id;
        Object o;
        TestCaseStep step = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            step = new TestCaseStep();
            step.setId(id);
            step.setActions(Util.getString(map, TestLinkResponseParams.ACTIONS.toString()));
            step.setActive(Util.getBoolean(map, TestLinkResponseParams.ACTIVE.toString()));
            Integer executionTypeValue = Util.getInteger(map, TestLinkResponseParams.EXECUTION_TYPE.toString());
            ExecutionType execution = ExecutionType.getExecutionType(executionTypeValue);
            step.setExecutionType(execution);
            step.setExpectedResults(Util.getString(map, TestLinkResponseParams.EXPECTED_RESULTS.toString()));
            step.setNumber(Util.getInteger(map, TestLinkResponseParams.STEP_NUMBER.toString()));
        }
        return step;
    }

    public static Map<String, Object> getTestCaseStepMap(TestCaseStep testCaseStep) {
        return Util.getTestCaseStepMap(testCaseStep, false);
    }

    public static Map<String, Object> getTestCaseStepMap(TestCaseStep testCaseStep, boolean internal) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.STEP_NUMBER.toString(), testCaseStep.getNumber());
        executionData.put(TestLinkParams.ACTIONS.toString(), testCaseStep.getActions());
        executionData.put(TestLinkParams.EXPECTED_RESULTS.toString(), testCaseStep.getExpectedResults());
        if (internal) {
            executionData.put(TestLinkParams.STEP_EXECUTION_TYPE.toString(), testCaseStep.getExecutionType().getValue());
        } else {
            executionData.put(TestLinkParams.EXECUTION_TYPE.toString(), (Object)testCaseStep.getExecutionType());
        }
        return executionData;
    }

    public static List<Map<String, Object>> getTestCaseStepResultMap(List<TestCaseStepResult> testCaseStepResults) {
        ArrayList<Map<String, Object>> steps = new ArrayList<Map<String, Object>>();
        if (testCaseStepResults != null && testCaseStepResults.size() > 0) {
            for (TestCaseStepResult step : testCaseStepResults) {
                HashMap<String, Object> testCaseStepMap = new HashMap<String, Object>();
                testCaseStepMap.put(TestLinkParams.NOTES.toString(), step.getNotes());
                testCaseStepMap.put(TestLinkParams.STEP_NUMBER.toString(), step.getNumber());
                testCaseStepMap.put(TestLinkParams.RESULT.toString(), step.getResult().toString());
                steps.add(testCaseStepMap);
            }
        }
        return steps;
    }

    public static Map<String, Object> getTestSuiteMap(TestSuite testSuite) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_SUITE_NAME.toString(), testSuite.getName());
        executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), testSuite.getTestProjectId());
        executionData.put(TestLinkParams.PARENT_ID.toString(), testSuite.getParentId());
        executionData.put(TestLinkParams.DETAILS.toString(), testSuite.getDetails());
        executionData.put(TestLinkParams.ORDER.toString(), testSuite.getOrder());
        executionData.put(TestLinkParams.CHECK_DUPLICATED_NAME.toString(), testSuite.getCheckDuplicatedName());
        executionData.put(TestLinkParams.ACTION_ON_DUPLICATED_NAME.toString(), testSuite.getActionOnDuplicatedName() != null ? testSuite.getActionOnDuplicatedName().toString() : null);
        return executionData;
    }

    public static TestSuite getTestSuite(Map<String, Object> map) {
        int id;
        Object o;
        TestSuite testSuite = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            testSuite = new TestSuite();
            testSuite.setId(id);
            testSuite.setDetails(Util.getString(map, TestLinkResponseParams.DETAILS.toString()));
            testSuite.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            testSuite.setParentId(Util.getInteger(map, TestLinkResponseParams.PARENT_ID.toString()));
            testSuite.setOrder(Util.getInteger(map, TestLinkResponseParams.ORDER.toString()));
        }
        return testSuite;
    }

    public static TestCase getTestCase(Map<String, Object> map) {
        TestCase testCase = null;
        if (map != null && map.size() > 0) {
            int id;
            Object o = map.get(TestLinkResponseParams.TEST_CASE_ID.toString());
            if (o == null) {
                o = map.get(TestLinkResponseParams.ID.toString());
            }
            if (o != null && (id = Integer.parseInt(o.toString())) > 0) {
                String fullExternalId;
                testCase = new TestCase();
                testCase.setId(id);
                testCase.setVersionId(Util.getInteger(map, TestLinkResponseParams.TEST_CASE_VERSION_ID.toString()));
                testCase.setVersion(Util.getInteger(map, TestLinkResponseParams.VERSION.toString()));
                testCase.setPreconditions(Util.getString(map, TestLinkResponseParams.PRECONDITIONS.toString()));
                testCase.setSummary(Util.getString(map, TestLinkResponseParams.SUMMARY.toString()));
                testCase.setParentId(Util.getInteger(map, TestLinkResponseParams.PARENT_ID.toString()));
                testCase.setOrder(Util.getInteger(map, TestLinkResponseParams.ORDER.toString()));
                testCase.setExecutionOrder(Util.getInteger(map, TestLinkResponseParams.EXECUTION_ORDER.toString()));
                String testCaseName = Util.getString(map, TestLinkResponseParams.TCASE_NAME.toString());
                if (testCaseName == null) {
                    testCaseName = Util.getString(map, TestLinkResponseParams.NAME.toString());
                }
                testCase.setName(testCaseName);
                Platform platform = null;
                String platformName = Util.getString(map, TestLinkResponseParams.PLATFORM_NAME.toString());
                Integer platformId = Util.getInteger(map, TestLinkResponseParams.PLATFORM_ID.toString());
                if (platformName != null || platformId != null) {
                    platform = new Platform();
                    platform.setId(platformId);
                    platform.setName(platformName);
                }
                testCase.setPlatform(platform);
                testCase.setFeatureId(Util.getInteger(map, TestLinkResponseParams.FEATURE_ID.toString()));
                testCase.setExternalId(Util.getInteger(map, TestLinkResponseParams.EXTERNAL_ID.toString()));
                if (testCase.getExternalId() == null) {
                    testCase.setExternalId(Util.getInteger(map, TestLinkResponseParams.EXTERNAL_ID2.toString()));
                }
                if ((fullExternalId = Util.getString(map, TestLinkResponseParams.FULL_TEST_CASE_EXTERNAL_ID.toString())) == null && (fullExternalId = Util.getString(map, TestLinkResponseParams.FULL_TEST_CASE_EXTERNAL_ID2.toString())) == null) {
                    fullExternalId = Util.getString(map, TestLinkResponseParams.EXTERNAL_ID.toString());
                }
                testCase.setFullExternalId(fullExternalId);
                Integer testCaseStatusId = Util.getInteger(map, TestLinkResponseParams.STATUS.toString());
                if (testCaseStatusId != null) {
                    TestCaseStatus status = TestCaseStatus.values()[TestCaseStatus.values().length - testCaseStatusId];
                    testCase.setTestCaseStatus(status);
                }
                Integer executionTypeValue = Util.getInteger(map, TestLinkResponseParams.EXECUTION_TYPE.toString());
                ExecutionType execution = ExecutionType.getExecutionType(executionTypeValue);
                testCase.setExecutionType(execution);
                ExecutionStatus executionStatus = ExecutionStatus.NOT_RUN;
                String executionStatusText = Util.getString(map, TestLinkResponseParams.EXEC_STATUS.toString());
                if (StringUtils.isNotBlank((CharSequence)executionStatusText)) {
                    executionStatus = ExecutionStatus.getExecutionStatus(executionStatusText.charAt(0));
                }
                testCase.setExecutionStatus(executionStatus);
                testCase.setTestProjectId(Util.getInteger(map, TestLinkParams.TEST_PROJECT_ID.toString()));
                testCase.setTestSuiteId(Util.getInteger(map, TestLinkParams.TEST_SUITE_ID2.toString()));
                Object[] stepsArray = Util.getArray(map, TestLinkResponseParams.STEPS.toString());
                if (stepsArray != null && stepsArray.length > 0) {
                    for (Object stepObject : stepsArray) {
                        Map stepMap = (Map)stepObject;
                        TestCaseStep step = Util.getTestCaseStep(stepMap);
                        testCase.getSteps().add(step);
                    }
                }
            }
        }
        return testCase;
    }

    public static Object[] getArray(Map<String, Object> map, String key) {
        Object[] array = null;
        if (map != null && map.size() > 0) {
            Object o = map.get(key);
            array = Util.castToArray(o);
        }
        return array;
    }

    public static Object[] castToArray(Object object) {
        Object[] array = null;
        if (object != null) {
            array = object instanceof String ? new Object[]{} : (Object[])object;
        }
        return array;
    }

    public static Map<String, Object> castToMap(Object object) {
        Map map = null;
        if (object != null) {
            map = object instanceof String ? Collections.emptyMap() : (Map)object;
        }
        return map;
    }

    public static Map<String, Object> getBuildMap(Build build) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), build.getTestPlanId());
        executionData.put(TestLinkParams.BUILD_NAME.toString(), build.getName());
        executionData.put(TestLinkParams.BUILD_NOTES.toString(), build.getNotes());
        return executionData;
    }

    public static Map<String, Object> getAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.FK_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getTestCaseAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_CASE_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getTestSuiteAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_SUITE_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getTestProjectAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.TEST_PROJECT_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getRequirementAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.REQUIREMENT_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getRequirementSpecificationAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.REQUIREMENT_SPECIFICATION_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Map<String, Object> getExecutionAttachmentMap(Attachment attachment) {
        HashMap<String, Object> executionData = new HashMap<String, Object>();
        executionData.put(TestLinkParams.EXECUTION_ID.toString(), attachment.getFkId());
        executionData.put(TestLinkParams.FK_TABLE.toString(), attachment.getFkTable());
        executionData.put(TestLinkParams.TITLE.toString(), attachment.getTitle());
        executionData.put(TestLinkParams.DESCRIPTION.toString(), attachment.getDescription());
        executionData.put(TestLinkParams.FILE_NAME.toString(), attachment.getFileName());
        executionData.put(TestLinkParams.FILE_TYPE.toString(), attachment.getFileType());
        executionData.put(TestLinkParams.CONTENT.toString(), attachment.getContent());
        return executionData;
    }

    public static Attachment getAttachment(Map<String, Object> map) {
        int id;
        Object o;
        Attachment attachment = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            attachment = new Attachment();
            attachment.setId(id);
            attachment.setFileName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            attachment.setFileType(Util.getString(map, TestLinkResponseParams.FILE_TYPE.toString()));
            attachment.setTitle(Util.getString(map, TestLinkResponseParams.TITLE.toString()));
            attachment.setContent(Util.getString(map, TestLinkResponseParams.CONTENT.toString()));
        }
        return attachment;
    }

    public static List<Map<String, Object>> getRequirementsGroupedByReqSpecMap(List<Requirement> requirements) {
        ArrayList<Map<String, Object>> requirementsGroupedByReqSpecMap = new ArrayList<Map<String, Object>>();
        HashMap<Integer, ArrayList<Integer>> tempMap = new HashMap<Integer, ArrayList<Integer>>();
        for (Requirement requirement : requirements) {
            ArrayList<Integer> requirementsArray = (ArrayList<Integer>)tempMap.get(requirement.getReqSpecId());
            if (requirementsArray == null) {
                requirementsArray = new ArrayList<Integer>();
            }
            requirementsArray.add(requirement.getId());
            tempMap.put(requirement.getReqSpecId(), requirementsArray);
        }
        Set entrySet = tempMap.entrySet();
        for (Map.Entry entry : entrySet) {
            HashMap<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("req_spec", entry.getKey());
            finalMap.put("requirements", entry.getValue());
            requirementsGroupedByReqSpecMap.add(finalMap);
        }
        return requirementsGroupedByReqSpecMap;
    }

    public static Execution getExecution(Map<String, Object> map) {
        int id;
        Object o;
        Execution execution = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            execution = new Execution();
            execution.setId(id);
            execution.setBuildId(Util.getInteger(map, TestLinkResponseParams.BUILD_ID.toString()));
            execution.setTesterId(Util.getInteger(map, TestLinkResponseParams.TESTER_ID.toString()));
            String statusText = Util.getString(map, TestLinkResponseParams.STATUS.toString());
            ExecutionStatus status = ExecutionStatus.getExecutionStatus(statusText.charAt(0));
            execution.setStatus(status);
            execution.setTestPlanId(Util.getInteger(map, TestLinkResponseParams.TEST_PLAN_ID.toString()));
            execution.setTestCaseVersionId(Util.getInteger(map, TestLinkResponseParams.TEST_CASE_VERSION_ID.toString()));
            execution.setTestCaseVersionNumber(Util.getInteger(map, TestLinkResponseParams.TEST_CASE_VERSION_NUMBER.toString()));
            Integer executionTypeText = Util.getInteger(map, TestLinkResponseParams.EXECUTION_TYPE.toString());
            ExecutionType executionType = ExecutionType.getExecutionType(executionTypeText);
            execution.setExecutionType(executionType);
            execution.setNotes(Util.getString(map, TestLinkResponseParams.NOTES.toString()));
            String timestamp = Util.getString(map, TestLinkResponseParams.EXECUTION_TS.toString());
            if (StringUtils.isNotBlank((CharSequence)timestamp)) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date executionTimeStamp = df.parse(timestamp);
                    execution.setExecutionTimeStamp(executionTimeStamp);
                }
                catch (ParseException e) {
                    LOG.log(Level.WARNING, "Failed to parse execution_ts: " + e.getMessage(), e);
                }
            }
        }
        return execution;
    }

    public static Build getBuild(Map<String, Object> map) {
        int id;
        Object o;
        Build build = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            build = new Build();
            build.setId(id);
            build.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            build.setNotes(Util.getString(map, TestLinkResponseParams.NOTES.toString()));
            build.setTestPlanId(Util.getInteger(map, TestLinkResponseParams.TEST_PLAN_ID.toString()));
            build.setIsActive(Util.getInteger(map, TestLinkResponseParams.ACTIVE.toString()));
            build.setIsOpen(Util.getInteger(map, TestLinkResponseParams.IS_OPEN.toString()));
            build.setReleaseDate(Util.getString(map, TestLinkResponseParams.RELEASE_DATE.toString()));
            build.setClosedDate(Util.getString(map, TestLinkResponseParams.CLOSED_DATE.toString()));
        }
        return build;
    }

    public static ReportTCResultResponse getReportTCResultResponse(Map<String, Object> map) {
        int id;
        Object o;
        ReportTCResultResponse reportTCResultResponse = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.ID.toString())) != null && (id = Integer.parseInt(o.toString())) > 0) {
            reportTCResultResponse = new ReportTCResultResponse();
            reportTCResultResponse.setExecutionId(id);
            reportTCResultResponse.setOperation(Util.getString(map, TestLinkResponseParams.OPERATIONS.toString()));
            reportTCResultResponse.setOverwrite(Util.getBoolean(map, TestLinkResponseParams.OVERWRITE.toString()));
            reportTCResultResponse.setStatus(Util.getBoolean(map, TestLinkResponseParams.STATUS.toString()));
            reportTCResultResponse.setMessage(Util.getString(map, TestLinkResponseParams.MESSAGE.toString()));
            reportTCResultResponse.setBugIDStatus(Util.getBoolean(map, TestLinkResponseParams.BUG_ID_STATUS.toString()));
            reportTCResultResponse.setCustomFieldStatus(Util.getBoolean(map, TestLinkResponseParams.CUSTOM_FIELD_STATUS.toString()));
        }
        return reportTCResultResponse;
    }

    public static CustomField getCustomField(Map<String, Object> map) {
        CustomField customField = null;
        if (map != null && map.size() > 0) {
            customField = new CustomField();
            customField.setId(Util.getInteger(map, TestLinkResponseParams.ID.toString()));
            customField.setDefaultValue(Util.getString(map, TestLinkResponseParams.DEFAULT_VALUE.toString()));
            customField.setDisplayOrder(Util.getInteger(map, TestLinkResponseParams.DISPLAY_ORDER.toString()));
            customField.setEnableOnDesign(Util.getBoolean(map, TestLinkResponseParams.ENABLE_ON_DESIGN.toString()));
            customField.setEnableOnExecution(Util.getBoolean(map, TestLinkResponseParams.ENABLE_ON_EXECUTION.toString()));
            customField.setEnableOnTestPlanDesign(Util.getBoolean(map, TestLinkResponseParams.ENABLE_ON_TEST_PLAN_DESIGN.toString()));
            customField.setLabel(Util.getString(map, TestLinkResponseParams.LABEL.toString()));
            customField.setLengthMax(Util.getInteger(map, TestLinkResponseParams.LENGTH_MAX.toString()));
            customField.setLengthMin(Util.getInteger(map, TestLinkResponseParams.LENGTH_MIN.toString()));
            customField.setLocation(Util.getInteger(map, TestLinkResponseParams.LOCATION.toString()));
            customField.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            customField.setPossibleValues(Util.getString(map, TestLinkResponseParams.POSSIBLE_VALUES.toString()));
            customField.setShowOnDesign(Util.getBoolean(map, TestLinkResponseParams.SHOW_ON_DESIGN.toString()));
            customField.setShowOnExecution(Util.getBoolean(map, TestLinkResponseParams.SHOW_ON_EXECUTION.toString()));
            customField.setShowOnTestPlanDesign(Util.getBoolean(map, TestLinkResponseParams.SHOW_ON_TEST_PLAN_DESIGN.toString()));
            customField.setType(Util.getInteger(map, TestLinkResponseParams.TYPE.toString()));
            customField.setValidRegexp(Util.getString(map, TestLinkResponseParams.VALID_REGEXP.toString()));
            customField.setValue(Util.getString(map, TestLinkResponseParams.VALUE.toString()));
        }
        return customField;
    }

    public static void putIfNotNullAndTrue(Map<String, Object> map, String key, Boolean boolValue) {
        if (Boolean.TRUE.equals(boolValue)) {
            map.put(key, 0);
        }
    }

    public static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static String getStringValueOrNull(Object o) {
        String value = null;
        if (o != null) {
            value = o.toString();
        }
        return value;
    }

    public static User getUser(Map<String, Object> map) {
        int dbID;
        Object o;
        User user = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.DB_ID.toString())) != null && (dbID = Integer.parseInt(o.toString())) > 0) {
            user = new User(dbID);
            user.setLogin(Util.getString(map, TestLinkResponseParams.LOGIN.toString()));
            user.setFirstName(Util.getString(map, TestLinkResponseParams.FIRST_NAME.toString()));
            user.setLastName(Util.getString(map, TestLinkResponseParams.LAST_NAME.toString()));
            user.setLocale(Util.getString(map, TestLinkResponseParams.LOCALE.toString()));
            user.setEmailAddress(Util.getString(map, TestLinkResponseParams.EMAIL_ADDRESS.toString()));
            user.setIsActive(Util.getInteger(map, TestLinkResponseParams.IS_ACTIVE.toString()));
            user.setUserApiKey(Util.getString(map, TestLinkResponseParams.USER_API_KEY.toString()));
            user.setLoginRegExp(Util.getString(map, TestLinkResponseParams.LOGIN_REGEXP.toString()));
            user.setTprojectRoles(Util.getInteger(map, TestLinkResponseParams.TPROJECT_ROLES.toString()));
            user.setTplanRoles(Util.getInteger(map, TestLinkResponseParams.TPLAN_ROLES.toString()));
            user.setGlobalRole(Util.getRole((Map)map.get(TestLinkResponseParams.GLOBAL_ROLE.toString())));
            user.setGlobalRoleID(Util.getInteger(map, TestLinkResponseParams.GLOBAL_ROLE_ID.toString()));
            user.setDefaultTestprojectID(Util.getInteger(map, TestLinkResponseParams.DEFAULT_TESTPROJECT_ID.toString()));
        }
        return user;
    }

    public static Role getRole(Map<String, Object> map) {
        int dbID;
        Object o;
        Role role = null;
        if (map != null && map.size() > 0 && (o = map.get(TestLinkResponseParams.DB_ID.toString())) != null && (dbID = Integer.parseInt(o.toString())) > 0) {
            role = new Role(dbID);
            role.setDescription(Util.getString(map, TestLinkResponseParams.DESCRIPTION.toString()));
            role.setName(Util.getString(map, TestLinkResponseParams.NAME.toString()));
            role.setRights((Object[])map.get(TestLinkResponseParams.RIGHTS.toString()));
        }
        return role;
    }
}

