/*
 * Decompiled with CFR 0.152.
 */
package br.eti.kinoshita.testlinkjavaapi;

import br.eti.kinoshita.testlinkjavaapi.BaseService;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkMethods;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkParams;
import br.eti.kinoshita.testlinkjavaapi.constants.TestLinkResponseParams;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Execution;
import br.eti.kinoshita.testlinkjavaapi.model.User;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import br.eti.kinoshita.testlinkjavaapi.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;

class MiscService
extends BaseService {
    MiscService(XmlRpcClient xmlRpcClient, String devKey) {
        super(xmlRpcClient, devKey);
    }

    protected Boolean checkDevKey(String devKey) throws TestLinkAPIException {
        boolean statusOk;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.DEV_KEY.toString(), devKey);
            Object response = this.executeXmlRpcCall(TestLinkMethods.CHECK_DEV_KEY.toString(), executionData);
            statusOk = Boolean.parseBoolean(response.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error verifying developer key: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return statusOk;
    }

    protected Boolean doesUserExist(String user) throws TestLinkAPIException {
        boolean userExist;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.USER.toString(), user);
            Object response = this.executeXmlRpcCall(TestLinkMethods.DOES_USER_EXIST.toString(), executionData);
            userExist = Boolean.parseBoolean(response.toString());
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error verifying if user exists: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return userExist;
    }

    protected User getUserByLogin(String login) throws TestLinkAPIException {
        User user;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.USER.toString(), login);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_USER_BY_LOGIN.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            user = Util.getUser(responseMap);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error verifying if user exists: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return user;
    }

    protected String sayHello() throws TestLinkAPIException {
        String message;
        try {
            Object response = this.executeXmlRpcCall(TestLinkMethods.SAY_HELLO.toString(), null);
            message = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error saying hello: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return message;
    }

    protected String about() throws TestLinkAPIException {
        String message;
        try {
            Object response = this.executeXmlRpcCall(TestLinkMethods.ABOUT.toString(), null);
            message = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error in about method: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return message;
    }

    protected Boolean setTestMode(Boolean testMode) throws TestLinkAPIException {
        Boolean result;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_MODE.toString(), testMode);
            Object response = this.executeXmlRpcCall(TestLinkMethods.SET_TEST_MODE.toString(), executionData);
            result = (Boolean)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error setting test mode: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return result;
    }

    protected String repeat(String str) throws TestLinkAPIException {
        String repeatMessage;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.STR.toString(), str);
            Object response = this.executeXmlRpcCall(TestLinkMethods.REPEAT.toString(), executionData);
            repeatMessage = (String)response;
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error setting test mode: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return repeatMessage;
    }

    protected Attachment uploadAttachment(Integer fkId, String fkTable, String title, String description, String fileName, String fileType, String content) throws TestLinkAPIException {
        Integer id = 0;
        Attachment attachment = new Attachment(id, fkId, fkTable, title, description, fileName, null, fileType, content);
        try {
            Map<String, Object> executionData = Util.getAttachmentMap(attachment);
            Object response = this.executeXmlRpcCall(TestLinkMethods.UPLOAD_ATTACHMENT.toString(), executionData);
            Map responseMap = (Map)response;
            id = Util.getInteger(responseMap, TestLinkResponseParams.ID.toString());
            attachment.setId(id);
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return attachment;
    }

    protected String[] getFullPath(Integer nodeId) throws TestLinkAPIException {
        String[] names = null;
        try {
            Map responseMap;
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.NODE_ID.toString(), nodeId);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_FULL_PATH.toString(), executionData);
            if (response instanceof Map && (responseMap = (Map)response).size() > 0) {
                Object value = responseMap.get(nodeId.toString());
                Object[] values = (Object[])value;
                names = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    names[i] = values[i].toString();
                }
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error uploading attachment: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return names;
    }

    protected Execution getLastExecutionResult(Integer testPlanId, Integer testCaseId, String testCaseExternalId, Integer platformId, String platformName, Integer buildId, String buildName, Integer options) throws TestLinkAPIException {
        Execution execution = null;
        try {
            HashMap<String, Object> executionData = new HashMap<String, Object>();
            executionData.put(TestLinkParams.TEST_PLAN_ID.toString(), testPlanId);
            executionData.put(TestLinkParams.TEST_CASE_ID.toString(), testCaseId);
            executionData.put(TestLinkParams.TEST_CASE_EXTERNAL_ID.toString(), testCaseExternalId);
            executionData.put(TestLinkParams.PLATFORM_ID.toString(), platformId);
            executionData.put(TestLinkParams.PLATFORM_NAME.toString(), platformName);
            executionData.put(TestLinkParams.BUILD_ID.toString(), buildId);
            executionData.put(TestLinkParams.BUILD_NAME.toString(), buildName);
            executionData.put(TestLinkParams.OPTIONS.toString(), options);
            Object response = this.executeXmlRpcCall(TestLinkMethods.GET_LAST_EXECUTION_RESULT.toString(), executionData);
            Object[] responseArray = Util.castToArray(response);
            Map responseMap = (Map)responseArray[0];
            if (responseMap.size() > 0) {
                execution = Util.getExecution(responseMap);
            }
        }
        catch (XmlRpcException xmlrpcex) {
            throw new TestLinkAPIException("Error retrieving last execution result: " + xmlrpcex.getMessage(), xmlrpcex);
        }
        return execution;
    }
}

