/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.asynctasks;

import android.os.AsyncTask;
import android.os.Build;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAsyncTask<Params, Progress, Result>
extends AsyncTask<Params, Progress, Result> {
    private List<Throwable> mExecuteExceptions;
    private WeakReference<AsyncTaskListener<Result>> mAsyncTaskListenerReference;

    public BaseAsyncTask(AsyncTaskListener<Result> listener) {
        this.setAsyncTaskListener(listener);
    }

    public AsyncTaskListener<Result> getAsyncTaskListener() {
        return this.mAsyncTaskListenerReference != null ? (AsyncTaskListener)this.mAsyncTaskListenerReference.get() : null;
    }

    public void setAsyncTaskListener(AsyncTaskListener<Result> mAsyncTaskListener) {
        this.mAsyncTaskListenerReference = new WeakReference<AsyncTaskListener<Result>>(mAsyncTaskListener);
    }

    public abstract boolean isSuccess(Result var1);

    protected void onPreExecute() {
        AsyncTaskListener<Result> asyncTaskListener = this.getAsyncTaskListener();
        if (asyncTaskListener != null) {
            asyncTaskListener.onAsyncTaskStart();
        }
    }

    protected void onPostExecute(Result result) {
        AsyncTaskListener<Result> asyncTaskListener = this.getAsyncTaskListener();
        if (asyncTaskListener != null) {
            if (this.isSuccess(result)) {
                asyncTaskListener.onAsyncTaskComplete(result);
            } else {
                asyncTaskListener.onAsyncTaskFail(result);
            }
            asyncTaskListener.onAsyncTaskFinish();
        }
    }

    protected void onCancelled() {
        AsyncTaskListener<Result> asyncTaskListener = this.getAsyncTaskListener();
        if (asyncTaskListener != null) {
            asyncTaskListener.onAsyncTaskCancelled();
            asyncTaskListener.onAsyncTaskFinish();
        }
    }

    public boolean executeCompat(Params ... params) {
        boolean executed = false;
        try {
            if (Build.VERSION.SDK_INT < 11) {
                this.execute(params);
                executed = true;
            } else {
                this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, params);
                executed = true;
            }
        }
        catch (Throwable t) {
            this.appendExecuteExceptions(t);
        }
        try {
            if (!executed) {
                this.execute(params);
            }
        }
        catch (Throwable t) {
            this.appendExecuteExceptions(t);
        }
        return executed;
    }

    private void appendExecuteExceptions(Throwable t) {
        if (this.mExecuteExceptions == null) {
            this.mExecuteExceptions = new ArrayList<Throwable>();
        }
        this.mExecuteExceptions.add(t);
    }

    public List<Throwable> getExecuteExceptions() {
        return this.mExecuteExceptions;
    }

    public static interface AsyncTaskListener<Result> {
        public void onAsyncTaskCancelled();

        public void onAsyncTaskComplete(Result var1);

        public void onAsyncTaskFail(Result var1);

        public void onAsyncTaskFinish();

        public void onAsyncTaskStart();
    }
}

