/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.asynctasks;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import br.com.tattobr.android.asynctasks.BaseAsyncTask;

public abstract class AsyncTaskFragment<Result>
extends Fragment {
    private AsyncTaskFragmentListener mAsyncTaskFragmentListener;
    private BaseAsyncTask.AsyncTaskListener<Result> mAsyncTaskListener;
    private Result mAsyncTaskResult;
    private BaseAsyncTask mAsyncTask;
    private boolean mStartDispatch;
    private boolean mStartDispatched;
    private boolean mFinishDispatch;
    private boolean mFinishDispatched;
    private boolean mFailDispatch;
    private boolean mFailDispatched;
    private boolean mCompleteDispatch;
    private boolean mCompleteDispatched;
    private boolean mCancelledDispatch;
    private boolean mCancelledDispatched;
    private boolean mPaused;

    public abstract BaseAsyncTask startAsyncTask();

    public abstract boolean isValidContext(Context var1);

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof AsyncTaskFragmentListener) || !this.isValidContext(context)) {
            throw new IllegalStateException("Context must implement fragment's callbacks.");
        }
        this.mAsyncTaskFragmentListener = (AsyncTaskFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mAsyncTaskFragmentListener = null;
    }

    public void onPause() {
        super.onPause();
        this.mPaused = true;
    }

    public void onResume() {
        super.onResume();
        this.mPaused = false;
        this.dispatchAsyncTaskStart();
        this.dispatchAsyncTaskFail(this.mAsyncTaskResult);
        this.dispatchAsyncTaskComplete(this.mAsyncTaskResult);
        this.dispatchAsyncTaskCancelled();
        this.dispatchAsyncTaskFinish();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (this.mAsyncTask == null) {
            this.mAsyncTask = this.startAsyncTask();
        }
    }

    public BaseAsyncTask.AsyncTaskListener<Result> getAsyncTaskListener() {
        if (this.mAsyncTaskListener == null) {
            this.mAsyncTaskListener = new BaseAsyncTask.AsyncTaskListener<Result>(){

                @Override
                public void onAsyncTaskCancelled() {
                    AsyncTaskFragment.this.mCancelledDispatch = true;
                    AsyncTaskFragment.this.dispatchAsyncTaskCancelled();
                }

                @Override
                public void onAsyncTaskComplete(Result result) {
                    AsyncTaskFragment.this.mCompleteDispatch = true;
                    AsyncTaskFragment.this.mAsyncTaskResult = result;
                    AsyncTaskFragment.this.dispatchAsyncTaskComplete(result);
                }

                @Override
                public void onAsyncTaskFail(Result result) {
                    AsyncTaskFragment.this.mFailDispatch = true;
                    AsyncTaskFragment.this.mAsyncTaskResult = result;
                    AsyncTaskFragment.this.dispatchAsyncTaskFail(result);
                }

                @Override
                public void onAsyncTaskFinish() {
                    AsyncTaskFragment.this.mFinishDispatch = true;
                    AsyncTaskFragment.this.dispatchAsyncTaskFinish();
                }

                @Override
                public void onAsyncTaskStart() {
                    AsyncTaskFragment.this.mStartDispatch = true;
                    AsyncTaskFragment.this.dispatchAsyncTaskStart();
                }
            };
        }
        return this.mAsyncTaskListener;
    }

    public void cancelTask() {
        if (this.mAsyncTask != null) {
            this.mAsyncTask.cancel(false);
            this.mAsyncTask = null;
        }
    }

    private void dispatchAsyncTaskCancelled() {
        if (this.mAsyncTaskFragmentListener != null && this.mCancelledDispatch && !this.mCancelledDispatched && !this.mPaused) {
            this.mCancelledDispatched = true;
            this.mAsyncTaskFragmentListener.getAsyncTaskListener(this).onAsyncTaskCancelled();
        }
    }

    private void dispatchAsyncTaskComplete(Result result) {
        if (this.mAsyncTaskFragmentListener != null && this.mCompleteDispatch && !this.mCompleteDispatched && !this.mPaused) {
            this.mCompleteDispatched = true;
            this.mAsyncTaskFragmentListener.getAsyncTaskListener(this).onAsyncTaskComplete(result);
        }
    }

    private void dispatchAsyncTaskFail(Result result) {
        if (this.mAsyncTaskFragmentListener != null && this.mFailDispatch && !this.mFailDispatched && !this.mPaused) {
            this.mFailDispatched = true;
            this.mAsyncTaskFragmentListener.getAsyncTaskListener(this).onAsyncTaskFail(result);
        }
    }

    private void dispatchAsyncTaskFinish() {
        if (this.mAsyncTaskFragmentListener != null && this.mFinishDispatch && !this.mFinishDispatched && !this.mPaused) {
            this.mFinishDispatched = true;
            this.mAsyncTaskFragmentListener.getAsyncTaskListener(this).onAsyncTaskFinish();
        }
    }

    private void dispatchAsyncTaskStart() {
        if (this.mAsyncTaskFragmentListener != null && this.mStartDispatch && !this.mStartDispatched && !this.mPaused) {
            this.mStartDispatched = true;
            this.mAsyncTaskFragmentListener.getAsyncTaskListener(this).onAsyncTaskStart();
        }
    }

    public static interface AsyncTaskFragmentListener {
        public BaseAsyncTask.AsyncTaskListener getAsyncTaskListener(AsyncTaskFragment var1);
    }
}

