/*
 * Decompiled with CFR 0.152.
 */
package br.com.tattobr.android.dialogs;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.CheckBox;
import android.widget.TextView;
import br.com.tattobr.android.dialogs.R;

public class AlertDialogFragment
extends DialogFragment {
    public static final String TAG = "tag";
    private static final String TITLE = "title";
    private static final String MESSAGE = "message";
    private static final String CHECKBOX = "checkbox";
    private static final String SHOW_CHECKBOX = "showCheckbox";
    private static final String CHECKBOX_CHECKED = "checkboxChecked";
    private static final String POSITIVE_BUTTON = "positive_label";
    private static final String NEGATIVE_BUTTON = "negative_label";
    private static final String SHOW_NEGATIVE_BUTTON = "showNegativeButton";
    private static final String TITLE_MESSAGE_AS_STRING = "titleMessageAsString";
    private static final String CANCELABLE = "cancelable";
    private static final String CANCEL_ON_TOUCH_OUTSIDE = "cancelOnTouchOutside";
    private static final String PARAMS = "params";

    public static AlertDialogFragment newInstance(int tag, int title, int message, boolean showNegativeButton) {
        return AlertDialogFragment.newInstance(tag, title, message, showNegativeButton, true, true, null);
    }

    public static AlertDialogFragment newInstance(int tag, int title, int message, boolean showNegativeButton, boolean cancelable, boolean cancelOnTouchOutside, Bundle params) {
        AlertDialogFragment frag = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putInt(TITLE, title);
        args.putInt(MESSAGE, message);
        args.putString(POSITIVE_BUTTON, null);
        args.putString(NEGATIVE_BUTTON, null);
        args.putBoolean(SHOW_CHECKBOX, true);
        args.putBoolean(SHOW_NEGATIVE_BUTTON, showNegativeButton);
        args.putBoolean(TITLE_MESSAGE_AS_STRING, false);
        args.putBoolean(CANCELABLE, cancelable);
        args.putBoolean(CANCEL_ON_TOUCH_OUTSIDE, cancelOnTouchOutside);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public static AlertDialogFragment newInstance(int tag, int title, int message, int checkbox) {
        return AlertDialogFragment.newInstance(tag, title, message, checkbox, false, true, true, true, null);
    }

    public static AlertDialogFragment newInstance(int tag, int title, int message, int checkbox, boolean checked) {
        return AlertDialogFragment.newInstance(tag, title, message, checkbox, checked, true, true, true, null);
    }

    public static AlertDialogFragment newInstance(int tag, int title, int message, int checkbox, boolean checkboxChecked, boolean showNegativeButton, boolean cancelable, boolean cancelOnTouchOutside, Bundle params) {
        AlertDialogFragment frag = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putInt(TITLE, title);
        args.putInt(MESSAGE, message);
        args.putInt(CHECKBOX, checkbox);
        args.putBoolean(SHOW_CHECKBOX, true);
        args.putBoolean(CHECKBOX_CHECKED, checkboxChecked);
        args.putBoolean(SHOW_NEGATIVE_BUTTON, showNegativeButton);
        args.putBoolean(TITLE_MESSAGE_AS_STRING, false);
        args.putBoolean(CANCELABLE, cancelable);
        args.putBoolean(CANCEL_ON_TOUCH_OUTSIDE, cancelOnTouchOutside);
        args.putString(POSITIVE_BUTTON, null);
        args.putString(NEGATIVE_BUTTON, null);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, boolean showNegativeButton) {
        return AlertDialogFragment.newInstance(tag, title, message, false, showNegativeButton, true, true, null);
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, boolean checkboxChecked, boolean showNegativeButton, boolean cancelable, boolean cancelOnTouchOutside, Bundle params) {
        AlertDialogFragment frag = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putString(TITLE, title);
        args.putString(MESSAGE, message);
        args.putBoolean(SHOW_CHECKBOX, false);
        args.putBoolean(CHECKBOX_CHECKED, checkboxChecked);
        args.putBoolean(SHOW_NEGATIVE_BUTTON, showNegativeButton);
        args.putBoolean(TITLE_MESSAGE_AS_STRING, true);
        args.putBoolean(CANCELABLE, cancelable);
        args.putBoolean(CANCEL_ON_TOUCH_OUTSIDE, cancelOnTouchOutside);
        args.putString(POSITIVE_BUTTON, null);
        args.putString(NEGATIVE_BUTTON, null);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, String positiveLabel, String negativeLabel) {
        return AlertDialogFragment.newInstance(tag, title, message, positiveLabel, negativeLabel, null);
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, String positiveLabel, String negativeLabel, Bundle params) {
        AlertDialogFragment frag = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putString(TITLE, title);
        args.putString(MESSAGE, message);
        args.putString(POSITIVE_BUTTON, positiveLabel);
        args.putString(NEGATIVE_BUTTON, negativeLabel);
        args.putBoolean(SHOW_NEGATIVE_BUTTON, true);
        args.putBoolean(SHOW_CHECKBOX, false);
        args.putBoolean(TITLE_MESSAGE_AS_STRING, true);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, int checkbox) {
        return AlertDialogFragment.newInstance(tag, title, message, checkbox, false, true, true, true, null);
    }

    public static AlertDialogFragment newInstance(int tag, String title, String message, int checkbox, boolean checkboxChecked, boolean showNegativeButton, boolean cancelable, boolean cancelOnTouchOutside, Bundle params) {
        AlertDialogFragment frag = new AlertDialogFragment();
        Bundle args = new Bundle();
        args.putInt(TAG, tag);
        args.putString(TITLE, title);
        args.putString(MESSAGE, message);
        args.putInt(CHECKBOX, checkbox);
        args.putBoolean(SHOW_CHECKBOX, true);
        args.putBoolean(CHECKBOX_CHECKED, checkboxChecked);
        args.putBoolean(SHOW_NEGATIVE_BUTTON, showNegativeButton);
        args.putBoolean(TITLE_MESSAGE_AS_STRING, true);
        args.putBoolean(CANCELABLE, cancelable);
        args.putBoolean(CANCEL_ON_TOUCH_OUTSIDE, cancelOnTouchOutside);
        args.putString(POSITIVE_BUTTON, null);
        args.putString(NEGATIVE_BUTTON, null);
        args.putBundle(PARAMS, params);
        frag.setArguments(args);
        return frag;
    }

    public AlertDialog onCreateDialog(Bundle savedInstanceState) {
        String title;
        String message;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        final Bundle args = this.getArguments();
        String positiveButton = null;
        String negativeButton = null;
        if (!args.getBoolean(TITLE_MESSAGE_AS_STRING)) {
            int messageId = args.getInt(MESSAGE);
            int titleId = args.getInt(TITLE);
            int positiveButtonId = args.getInt(POSITIVE_BUTTON);
            int negativeButtonId = args.getInt(NEGATIVE_BUTTON);
            message = this.getString(messageId);
            title = this.getString(titleId);
            positiveButton = this.getString(positiveButtonId);
            negativeButton = this.getString(negativeButtonId);
        } else {
            message = args.getString(MESSAGE);
            title = args.getString(TITLE);
            positiveButton = args.getString(POSITIVE_BUTTON);
            negativeButton = args.getString(NEGATIVE_BUTTON);
        }
        builder.setTitle((CharSequence)title);
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_alert_checkbox, null);
        TextView textView = (TextView)view.findViewById(16908308);
        final CheckBox checkBoxView = (CheckBox)view.findViewById(0x1020001);
        textView.setText((CharSequence)message);
        if (args.getBoolean(SHOW_CHECKBOX, false)) {
            int checkbox = args.getInt(CHECKBOX);
            checkBoxView.setText(checkbox);
            checkBoxView.setVisibility(0);
            checkBoxView.setChecked(args.getBoolean(CHECKBOX_CHECKED, false));
        } else {
            checkBoxView.setVisibility(8);
        }
        builder.setView(view);
        builder.setPositiveButton((CharSequence)(positiveButton == null ? this.getString(17039379) : positiveButton), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (AlertDialogFragment.this.getActivity() instanceof AlertDialogFragmentListener) {
                    ((AlertDialogFragmentListener)AlertDialogFragment.this.getActivity()).onAlertDialogPositiveButton(args.getInt(AlertDialogFragment.TAG), checkBoxView.isChecked(), args.getBundle(AlertDialogFragment.PARAMS));
                }
                if (AlertDialogFragment.this.getParentFragment() instanceof AlertDialogFragmentListener) {
                    ((AlertDialogFragmentListener)AlertDialogFragment.this.getParentFragment()).onAlertDialogPositiveButton(args.getInt(AlertDialogFragment.TAG), checkBoxView.isChecked(), args.getBundle(AlertDialogFragment.PARAMS));
                }
            }
        });
        if (args.getBoolean(SHOW_NEGATIVE_BUTTON, false)) {
            builder.setNegativeButton((CharSequence)(negativeButton == null ? this.getString(17039369) : negativeButton), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    if (AlertDialogFragment.this.getActivity() instanceof AlertDialogFragmentListener) {
                        ((AlertDialogFragmentListener)AlertDialogFragment.this.getActivity()).onAlertDialogNegativeButton(args.getInt(AlertDialogFragment.TAG), checkBoxView.isChecked(), args.getBundle(AlertDialogFragment.PARAMS));
                    }
                    if (AlertDialogFragment.this.getParentFragment() instanceof AlertDialogFragmentListener) {
                        ((AlertDialogFragmentListener)AlertDialogFragment.this.getParentFragment()).onAlertDialogNegativeButton(args.getInt(AlertDialogFragment.TAG), checkBoxView.isChecked(), args.getBundle(AlertDialogFragment.PARAMS));
                    }
                }
            });
        }
        this.setCancelable(args.getBoolean(CANCELABLE));
        AlertDialog d = builder.create();
        d.setCanceledOnTouchOutside(args.getBoolean(CANCEL_ON_TOUCH_OUTSIDE));
        return d;
    }

    public static interface AlertDialogFragmentListener {
        public void onAlertDialogNegativeButton(int var1, boolean var2, Bundle var3);

        public void onAlertDialogPositiveButton(int var1, boolean var2, Bundle var3);
    }
}

