/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.commons;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class ZapInfo {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_KEY = "";
    private static final long DEFAULT_INITIALIZATION_TIMEOUT_IN_MILLIS = 120000L;
    private static final String DEFAULT_OPTIONS = "-daemon -config api.disablekey=true -config api.incerrordetails=true -config proxy.ip=0.0.0.0";
    private String host;
    private Integer port;
    private String apiKey;
    private String path;
    private String options;
    private long initializationTimeoutInMillis;
    private boolean shouldRunWithDocker;

    public static Builder builder() {
        return new Builder();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getOptions() {
        return this.options;
    }

    public long getInitializationTimeoutInMillis() {
        return this.initializationTimeoutInMillis;
    }

    public boolean shouldRunWithDocker() {
        return this.shouldRunWithDocker;
    }

    private ZapInfo(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.apiKey = builder.apiKey;
        this.path = builder.path;
        this.options = builder.options;
        this.initializationTimeoutInMillis = builder.initializationTimeoutInMillis;
        this.shouldRunWithDocker = builder.shouldRunWithDocker;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("host", (Object)this.host).append("port", (Object)this.port).append("apiKey", (Object)this.apiKey).append("path", (Object)this.path).append("options", (Object)this.options).append("initializationTimeout", this.initializationTimeoutInMillis).append("shouldRunWithDocker", this.shouldRunWithDocker).toString();
    }

    public static class Builder {
        private String host = "localhost";
        private Integer port;
        private String apiKey = "";
        private String path;
        private String options = "-daemon -config api.disablekey=true -config api.incerrordetails=true -config proxy.ip=0.0.0.0";
        private Long initializationTimeoutInMillis = 120000L;
        private boolean shouldRunWithDocker;

        public ZapInfo buildToUseRunningZap(String host, int port) {
            return this.host(host).port(port).build();
        }

        public ZapInfo buildToUseRunningZap(String host, int port, String apiKey) {
            return this.host(host).port(port).apiKey(apiKey).build();
        }

        public ZapInfo buildToRunZap(int port, String path) {
            return this.port(port).path(path).build();
        }

        public ZapInfo buildToRunZap(int port, String path, String options) {
            return this.port(port).path(path).options(options).build();
        }

        public ZapInfo buildToRunZap(int port, String path, String options, String apiKey) {
            return this.port(port).path(path).options(options).apiKey(apiKey).build();
        }

        public ZapInfo buildToRunZapWithDocker(int port) {
            return this.shouldRunWithDocker(true).port(port).build();
        }

        public ZapInfo buildToRunZapWithDocker(int port, String options) {
            return this.shouldRunWithDocker(true).port(port).options(options).build();
        }

        public ZapInfo buildToRunZapWithDocker(int port, String options, String apiKey) {
            return this.shouldRunWithDocker(true).port(port).options(options).apiKey(apiKey).build();
        }

        public Builder host(String host) {
            if (host != null) {
                this.host = host;
            }
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder apiKey(String apiKey) {
            if (apiKey != null) {
                this.apiKey = apiKey;
            }
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder options(String options) {
            if (options != null) {
                this.options = options;
            }
            return this;
        }

        public Builder initializationTimeoutInMillis(Long initializationTimeoutInMillis) {
            if (initializationTimeoutInMillis != null) {
                this.initializationTimeoutInMillis = initializationTimeoutInMillis;
            }
            return this;
        }

        public Builder shouldRunWithDocker(boolean shouldRunWithDocker) {
            this.shouldRunWithDocker = shouldRunWithDocker;
            return this;
        }

        public ZapInfo build() {
            return new ZapInfo(this);
        }
    }
}

