/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.zaproxy.clientapi.core;

import br.com.softplan.security.zap.zaproxy.clientapi.core.Alert;
import br.com.softplan.security.zap.zaproxy.clientapi.core.AlertsFile;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponse;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseElement;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseFactory;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseList;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseSet;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApiException;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Acsrf;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.AjaxSpider;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Ascan;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Authentication;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Autoupdate;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Break;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Context;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Core;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.ForcedUser;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.HttpSessions;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.ImportLogFiles;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Params;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Pnh;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Pscan;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Script;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Search;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.SessionManagement;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Spider;
import br.com.softplan.security.zap.zaproxy.clientapi.gen.Users;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ClientApi {
    private Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("localhost", 8090));
    private boolean debug = false;
    private PrintStream debugStream = System.out;
    public Acsrf acsrf = new Acsrf(this);
    public AjaxSpider ajaxSpider = new AjaxSpider(this);
    public Ascan ascan = new Ascan(this);
    public Authentication authentication = new Authentication(this);
    public Autoupdate autoupdate = new Autoupdate(this);
    public Break brk = new Break(this);
    public Context context = new Context(this);
    public Core core = new Core(this);
    public ForcedUser forcedUser = new ForcedUser(this);
    public HttpSessions httpSessions = new HttpSessions(this);
    public ImportLogFiles logImportFiles = new ImportLogFiles(this);
    public Params params = new Params(this);
    public Pnh pnh = new Pnh(this);
    public Pscan pscan = new Pscan(this);
    public Search search = new Search(this);
    public Script script = new Script(this);
    public SessionManagement sessionManagement = new SessionManagement(this);
    public Spider spider = new Spider(this);
    public Users users = new Users(this);

    public ClientApi(String zapAddress, int zapPort) {
        this(zapAddress, zapPort, false);
    }

    public ClientApi(String zapAddress, int zapPort, boolean debug) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(zapAddress, zapPort));
        this.debug = debug;
    }

    public void setDebugStream(PrintStream debugStream) {
        this.debugStream = debugStream;
    }

    public void accessUrl(String url) throws ClientApiException {
        this.accessUrlViaProxy(this.proxy, url);
    }

    private int statusToInt(ApiResponse response) {
        return Integer.parseInt(((ApiResponseElement)response).getValue());
    }

    public void checkAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts) throws ClientApiException {
        HashMap<String, List<Alert>> results = this.checkForAlerts(ignoreAlerts, requireAlerts);
        this.verifyAlerts(results.get("requireAlerts"), results.get("reportAlerts"));
    }

    private void verifyAlerts(List<Alert> requireAlerts, List<Alert> reportAlerts) throws ClientApiException {
        StringBuilder sb = new StringBuilder();
        if (reportAlerts.size() > 0) {
            sb.append("Found ").append(reportAlerts.size()).append(" alerts\n");
            for (Alert alert : reportAlerts) {
                sb.append('\t');
                sb.append(alert.toString());
                sb.append('\n');
            }
        }
        if (requireAlerts != null && requireAlerts.size() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append("Not found ").append(requireAlerts.size()).append(" alerts\n");
            for (Alert alert : requireAlerts) {
                sb.append('\t');
                sb.append(alert.toString());
                sb.append('\n');
            }
        }
        if (sb.length() > 0) {
            if (this.debug) {
                this.debugStream.println("Failed: " + sb.toString());
            }
            throw new ClientApiException(sb.toString());
        }
    }

    public void checkAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts, File outputFile) throws ClientApiException {
        HashMap<String, List<Alert>> results = this.checkForAlerts(ignoreAlerts, requireAlerts);
        int alertsFound = results.get("reportAlerts").size();
        int alertsNotFound = results.get("requireAlerts").size();
        int alertsIgnored = results.get("ignoredAlerts").size();
        String resultsString = String.format("Alerts Found: %d, Alerts required but not found: %d, Alerts ignored: %d", alertsFound, alertsNotFound, alertsIgnored);
        try {
            AlertsFile.saveAlertsToFile(results.get("requireAlerts"), results.get("reportAlerts"), results.get("ignoredAlerts"), outputFile);
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
        if (alertsFound > 0 || alertsNotFound > 0) {
            throw new ClientApiException("Check Alerts Failed!\n" + resultsString);
        }
        if (this.debug) {
            this.debugStream.println("Check Alerts Passed!\n" + resultsString);
        }
    }

    public List<Alert> getAlerts(String baseUrl, int start, int count) throws ClientApiException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        ApiResponse response = this.core.alerts(baseUrl, String.valueOf(start), String.valueOf(count));
        if (response != null && response instanceof ApiResponseList) {
            ApiResponseList alertList = (ApiResponseList)response;
            for (ApiResponse resp : alertList.getItems()) {
                ApiResponseSet alertSet = (ApiResponseSet)resp;
                alerts.add(new Alert(alertSet.getAttribute("alert"), alertSet.getAttribute("url"), Alert.Risk.valueOf(alertSet.getAttribute("risk")), Alert.Confidence.valueOf(alertSet.getAttribute("confidence")), alertSet.getAttribute("param"), alertSet.getAttribute("other"), alertSet.getAttribute("attack"), alertSet.getAttribute("description"), alertSet.getAttribute("reference"), alertSet.getAttribute("solution"), alertSet.getAttribute("evidence"), Integer.parseInt(alertSet.getAttribute("cweid")), Integer.parseInt(alertSet.getAttribute("wascid"))));
            }
        }
        return alerts;
    }

    private HashMap<String, List<Alert>> checkForAlerts(List<Alert> ignoreAlerts, List<Alert> requireAlerts) throws ClientApiException {
        ArrayList<Alert> reportAlerts = new ArrayList<Alert>();
        ArrayList<Alert> ignoredAlerts = new ArrayList<Alert>();
        List<Alert> alerts = this.getAlerts(null, -1, -1);
        block0: for (Alert alert : alerts) {
            boolean ignore = false;
            if (ignoreAlerts != null) {
                for (Alert ignoreAlert : ignoreAlerts) {
                    if (!alert.matches(ignoreAlert)) continue;
                    if (this.debug) {
                        this.debugStream.println("Ignoring alert " + ignoreAlert);
                    }
                    ignoredAlerts.add(alert);
                    ignore = true;
                    break;
                }
            }
            if (!ignore) {
                reportAlerts.add(alert);
            }
            if (requireAlerts == null) continue;
            for (Alert requireAlert : requireAlerts) {
                if (!alert.matches(requireAlert)) continue;
                if (this.debug) {
                    this.debugStream.println("Found alert " + alert);
                }
                requireAlerts.remove(requireAlert);
                reportAlerts.remove(alert);
                continue block0;
            }
        }
        HashMap<String, List<Alert>> results = new HashMap<String, List<Alert>>();
        results.put("reportAlerts", reportAlerts);
        results.put("requireAlerts", requireAlerts);
        results.put("ignoredAlerts", ignoredAlerts);
        return results;
    }

    private void accessUrlViaProxy(Proxy proxy, String apiurl) throws ClientApiException {
        try {
            URL url = new URL(apiurl);
            if (this.debug) {
                this.debugStream.println("Open URL: " + apiurl);
            }
            HttpURLConnection uc = (HttpURLConnection)url.openConnection(proxy);
            uc.connect();
            try {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    if (!this.debug) continue;
                    this.debugStream.println(inputLine);
                }
                in.close();
            }
            catch (IOException e) {
                if (this.debug) {
                    this.debugStream.println("Ignoring exception " + e);
                }
            }
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    public ApiResponse callApi(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        Document dom = this.callApiDom(component, type, method, params);
        return ApiResponseFactory.getResponse(dom.getFirstChild());
    }

    private Document callApiDom(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        try {
            URL url = ClientApi.buildZapRequestUrl("xml", component, type, method, params);
            if (this.debug) {
                this.debugStream.println("Open URL: " + url);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(this.getConnectionInputStream(url));
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    private InputStream getConnectionInputStream(URL url) throws IOException {
        HttpURLConnection uc = (HttpURLConnection)url.openConnection(this.proxy);
        uc.connect();
        if (uc.getResponseCode() >= 400) {
            return uc.getErrorStream();
        }
        return uc.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] callApiOther(String component, String type, String method, Map<String, String> params) throws ClientApiException {
        try {
            URL url = ClientApi.buildZapRequestUrl("other", component, type, method, params);
            if (this.debug) {
                this.debugStream.println("Open URL: " + url);
            }
            InputStream in = this.getConnectionInputStream(url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            try {
                int bytesRead;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                out.close();
                in.close();
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new ClientApiException(e);
        }
    }

    private static URL buildZapRequestUrl(String format, String component, String type, String method, Map<String, String> params) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://zap/");
        sb.append(format);
        sb.append('/');
        sb.append(component);
        sb.append('/');
        sb.append(type);
        sb.append('/');
        sb.append(method);
        sb.append('/');
        if (params != null) {
            sb.append('?');
            for (Map.Entry<String, String> p : params.entrySet()) {
                sb.append(ClientApi.encodeQueryParam(p.getKey()));
                sb.append('=');
                if (p.getValue() != null) {
                    sb.append(ClientApi.encodeQueryParam(p.getValue()));
                }
                sb.append('&');
            }
        }
        return new URL(sb.toString());
    }

    private static String encodeQueryParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return param;
        }
    }

    public void addExcludeFromContext(String apikey, String contextName, String regex) throws Exception {
        this.context.excludeFromContext(apikey, contextName, regex);
    }

    public void addIncludeInContext(String apikey, String contextName, String regex) throws Exception {
        this.context.includeInContext(apikey, contextName, regex);
    }

    public void includeOneMatchingNodeInContext(String apikey, String contextName, String regex) throws Exception {
        List<String> sessionUrls = this.getSessionUrls();
        boolean foundOneMatch = false;
        for (String sessionUrl : sessionUrls) {
            if (!sessionUrl.matches(regex)) continue;
            if (foundOneMatch) {
                this.addExcludeFromContext(apikey, contextName, sessionUrl);
                continue;
            }
            foundOneMatch = true;
        }
        if (!foundOneMatch) {
            throw new Exception("Unexpected result: No url found in site tree matching regex " + regex);
        }
    }

    private List<String> getSessionUrls() throws Exception {
        ArrayList<String> sessionUrls = new ArrayList<String>();
        ApiResponse response = this.core.urls();
        if (response != null && response instanceof ApiResponseList) {
            ApiResponseElement urlList = (ApiResponseElement)((ApiResponseList)response).getItems().get(0);
            for (ApiResponse element : ((ApiResponseList)response).getItems()) {
                URL url = new URL(((ApiResponseElement)element).getValue());
                sessionUrls.add(url.getProtocol() + "://" + url.getHost() + url.getPath());
            }
            System.out.println(urlList);
        }
        return sessionUrls;
    }

    public void activeScanSiteInScope(String apikey, String url) throws Exception {
        this.ascan.scan(apikey, url, "true", "true", "", "", "");
        int status = 0;
        while (status < 100) {
            status = this.statusToInt(this.ascan.status(""));
            if (this.debug) {
                String format = "Scanning %s Progress: %d%%";
                System.out.println(String.format(format, url, status));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

