/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.zaproxy.clientapi.core;

import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponse;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseElement;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseFactory;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApiException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class ApiResponseSet
extends ApiResponse {
    private String[] attributes = null;
    private Map<String, String> values = null;

    public ApiResponseSet(String name, String[] attributes) {
        super(name);
        this.attributes = attributes;
    }

    public ApiResponseSet(String name, Map<String, String> values) {
        super(name);
        this.values = values;
    }

    public ApiResponseSet(Node node) throws ClientApiException {
        super(node.getNodeName());
        this.values = new HashMap<String, String>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ApiResponseElement elem = (ApiResponseElement)ApiResponseFactory.getResponse(child);
            this.values.put(elem.getName(), elem.getValue());
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.values.get(name);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("ApiResponseSet ");
        sb.append(this.getName());
        sb.append(" : [\n");
        for (Map.Entry<String, String> val : this.values.entrySet()) {
            for (int i = 0; i < indent + 1; ++i) {
                sb.append("\t");
            }
            sb.append(val.getKey());
            sb.append(" = ");
            sb.append(val.getValue());
            sb.append("\n");
        }
        for (int i = 0; i < indent; ++i) {
            sb.append("\t");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

